/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();

    private ProcessingContext() {
    }

    static void init(ProcessingEnvironment processingEnv) {
        CTX.set(new Ctx(processingEnv));
        APContext.init(processingEnv);
    }

    static FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return APContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    static String diAnnotation() {
        return ProcessingContext.CTX.get().diAnnotation;
    }

    static void validateModule(String fqn) {
        ModuleElement module = APContext.getProjectModuleElement();
        if (module != null && !ProcessingContext.CTX.get().validated && !module.isUnnamed()) {
            ProcessingContext.CTX.get().validated = true;
            boolean injectPresent = ProcessingContext.CTX.get().injectPresent;
            boolean warnHttp = ProcessingContext.CTX.get().warnHttp;
            try (BufferedReader reader = APContext.getModuleInfoReader();){
                AtomicBoolean noInjectPlugin = new AtomicBoolean(injectPresent);
                AtomicBoolean noHttpPlugin = new AtomicBoolean(warnHttp);
                boolean noProvides = reader.lines().map(s -> {
                    if (injectPresent && s.contains("io.avaje.validation.plugin")) {
                        noInjectPlugin.set(false);
                    }
                    if (injectPresent && warnHttp && s.contains("io.avaje.validation.http")) {
                        noInjectPlugin.set(false);
                        noHttpPlugin.set(false);
                    }
                    return s;
                }).noneMatch(s -> s.contains(fqn));
                if (noProvides) {
                    APContext.logError(module, "Missing `provides io.avaje.validation.Validator.GeneratedComponent with %s;`", fqn);
                }
                if (noHttpPlugin.get()) {
                    APContext.logWarn(module, "`requires io.avaje.validation.http` must be explicity added or else avaje-inject may fail to detect the default http validator, validator, and method AOP validator", fqn);
                } else if (noInjectPlugin.get()) {
                    APContext.logWarn(module, "`requires io.avaje.validation.plugin` must be explicity added or else avaje-inject may fail to detect the default validator and method AOP validator", fqn);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static ModuleElement getModuleElement(Element e) {
        if (e == null || e instanceof ModuleElement) {
            return (ModuleElement)e;
        }
        return ProcessingContext.getModuleElement(e.getEnclosingElement());
    }

    static void clear() {
        CTX.remove();
        APContext.clear();
    }

    private static final class Ctx {
        private final String diAnnotation;
        private final boolean warnHttp;
        private final boolean injectPresent;
        private boolean validated;

        Ctx(ProcessingEnvironment env) {
            boolean jakarta;
            Elements elements = env.getElementUtils();
            this.injectPresent = elements.getTypeElement("io.avaje.inject.Component") != null;
            this.warnHttp = elements.getTypeElement("io.avaje.http.api.Controller") != null;
            boolean bl = jakarta = elements.getTypeElement("jakarta.inject.Singleton") != null;
            this.diAnnotation = this.injectPresent ? "io.avaje.inject.Component" : (jakarta ? "jakarta.inject.Singleton" : "javax.inject.Singleton");
        }
    }
}

