/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;

public final class ProcessorUtils {
    private static final Pattern WHITE_SPACE_REGEX = Pattern.compile("\\s+(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    private static final Pattern COMMA_PATTERN = Pattern.compile(", (?=(?:[^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)");
    private static final Pattern PARENTHESIS_CONTENT = Pattern.compile("\\((.*?)\\)");
    private static final Map<String, String> BOX_MAP = Map.of("char", "Character", "byte", "Byte", "int", "Integer", "long", "Long", "short", "Short", "double", "Double", "float", "Float", "boolean", "Boolean");

    private ProcessorUtils() {
    }

    public static String boxedPrimitive(String type) {
        String wrapped = BOX_MAP.get(type);
        return wrapped != null ? "java.lang." + wrapped : null;
    }

    public static boolean isPrimitive(String type) {
        return BOX_MAP.containsKey(type);
    }

    public static String packageOf(String fqn) {
        return fqn.replace("." + ProcessorUtils.shortType(fqn), "");
    }

    public static String shortType(String fqn) {
        int p = fqn.lastIndexOf(46);
        if (p == -1) {
            return fqn;
        }
        Object result = "";
        boolean foundClass = false;
        for (String part : fqn.split("\\.")) {
            char firstChar = part.charAt(0);
            if (!foundClass && !Character.isUpperCase(firstChar) && (Character.isAlphabetic(firstChar) || !Character.isJavaIdentifierStart(firstChar))) continue;
            foundClass = true;
            result = (String)result + (((String)result).isEmpty() ? "" : ".") + part;
        }
        if (((String)result).isBlank()) {
            return fqn.substring(p + 1);
        }
        return result;
    }

    public static String trimAnnotations(String input) {
        input = COMMA_PATTERN.matcher(input).replaceAll(",");
        return ProcessorUtils.cutAnnotations(input);
    }

    private static String cutAnnotations(String input) {
        int pos = input.indexOf("@");
        if (pos == -1) {
            return input;
        }
        Matcher matcher = WHITE_SPACE_REGEX.matcher(input);
        int currentIndex = 0;
        if (matcher.find()) {
            currentIndex = matcher.start();
        }
        String result = input.substring(0, pos) + input.substring(currentIndex + 1);
        return ProcessorUtils.cutAnnotations(result);
    }

    public static String commonParent(String firstPkg, String secondPkg) {
        int next;
        if (secondPkg == null) {
            return firstPkg;
        }
        if (firstPkg == null) {
            return ProcessorUtils.packageOf(secondPkg);
        }
        if (secondPkg.startsWith(firstPkg)) {
            return firstPkg;
        }
        do {
            if ((next = firstPkg.lastIndexOf(46)) <= -1 || !secondPkg.startsWith(firstPkg = firstPkg.substring(0, next))) continue;
            return firstPkg;
        } while (next > -1);
        return firstPkg;
    }

    public static boolean isVarArg(VariableElement element, int position) {
        String methodString = ProcessorUtils.trimAnnotations(element.getEnclosingElement().toString());
        String typeString = ProcessorUtils.trimAnnotations(element.asType().toString()).replace("[]", "");
        Matcher matcher = PARENTHESIS_CONTENT.matcher(methodString);
        if (matcher.find()) {
            String param = matcher.group(1).split(",")[position];
            return param.replace("[]", "").contains(typeString) && param.endsWith("...");
        }
        return false;
    }

    public static boolean hasAnnotationWithName(Element element, String simpleName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!simpleName.equals(annotationMirror.getAnnotationType().asElement().getSimpleName().toString())) continue;
            return true;
        }
        return false;
    }

    public static String sanitizeImports(String input) {
        int pos = input.indexOf("@");
        if (pos == -1) {
            return ProcessorUtils.removeInvalidChars(input);
        }
        String start = pos == 0 ? input.substring(0, pos) : "";
        return start + ProcessorUtils.removeInvalidChars(input.substring(input.lastIndexOf(32) + 1));
    }

    private static String removeInvalidChars(String type) {
        return type.replaceAll("[^\\n\\r\\t $;\\w.]", "");
    }

    public static String extractEnclosingFQN(String fqn) {
        String fullResult;
        int p = fqn.lastIndexOf(46);
        if (p == -1) {
            return fqn;
        }
        StringBuilder result = new StringBuilder();
        boolean foundClass = false;
        boolean firstClass = true;
        for (String part : fqn.split("\\.")) {
            if (Character.isUpperCase(part.charAt(0))) {
                foundClass = true;
            }
            result.append(foundClass && !firstClass ? "/" : ".").append(part);
            if (!foundClass) continue;
            firstClass = false;
        }
        if (result.charAt(0) == '.') {
            result.deleteCharAt(0);
        }
        if ((p = (fullResult = result.toString()).lastIndexOf(47)) == -1) {
            return fullResult;
        }
        return fullResult.substring(0, p);
    }
}

