/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.Append;
import io.avaje.validation.generator.ProcessingContext;
import io.avaje.validation.generator.ProcessorUtils;
import io.avaje.validation.generator.Util;
import io.avaje.validation.generator.ValidMethodReader;
import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.JavaFileObject;

final class SimpleParamBeanWriter {
    private final ValidMethodReader beanReader;
    private final String adapterShortName;
    private final String adapterPackage;
    private final String adapterFullName;
    private Append writer;

    SimpleParamBeanWriter(ValidMethodReader beanReader) {
        this.beanReader = beanReader;
        ExecutableElement method = beanReader.getBeanType();
        this.adapterPackage = ProcessorUtils.packageOf(method.getEnclosingElement().asType().toString());
        this.adapterFullName = this.adapterPackage + "." + method.getSimpleName().toString().transform(str -> str.substring(0, 1).toUpperCase() + str.substring(1)) + "ParamProvider";
        this.adapterShortName = Util.shortName(this.adapterFullName);
    }

    String fullName() {
        return this.adapterFullName;
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = APContext.createSourceFile(this.adapterFullName, new Element[0]);
        return jfo.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        this.writeMethods();
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer);
    }

    private void writePackage() {
        this.writer.append("package %s;", this.adapterPackage).eol().eol();
    }

    private void writeClassStart() {
        this.writer.append("@Generated\n@%s\npublic final class %s implements MethodAdapterProvider {\n", Util.shortName(ProcessingContext.diAnnotation()), this.adapterShortName).eol();
    }

    private void writeMethods() {
        this.beanReader.writeValidatorMethod(this.writer);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }
}

