/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.AvajeValidPrism;
import io.avaje.validation.generator.GenericTypeMap;
import io.avaje.validation.generator.JakartaValidPrism;
import io.avaje.validation.generator.JavaxValidPrism;
import io.avaje.validation.generator.ProcessorUtils;
import io.avaje.validation.generator.UType;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class Util {
    private static final Pattern WHITE_SPACE_REGEX = Pattern.compile("\\s+(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    private static final Pattern COMMA_PATTERN = Pattern.compile(", (?=(?:[^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)");
    static final Pattern mapSplitString = Pattern.compile("\\s[A-Za-z0-9]+,|,");
    static final Set<String> BASIC_TYPES = Set.of("java.lang.String", "java.math.BigDecimal");

    private Util() {
    }

    static boolean isValid(Element e) {
        return AvajeValidPrism.isPresent(e) || JavaxValidPrism.isPresent(e) || JakartaValidPrism.isPresent(e);
    }

    public static boolean isNullable(Element p) {
        for (AnnotationMirror annotationMirror : p.getAnnotationMirrors()) {
            if (!"Nullable".equalsIgnoreCase(Util.shortName(annotationMirror.getAnnotationType().toString()))) continue;
            return true;
        }
        return false;
    }

    static boolean validImportType(String type) {
        return type.indexOf(46) > 0 && !type.startsWith("java.lang.") || type.startsWith("java.lang.") && type.replace("java.lang.", "").transform(s -> s.contains(".")) != false;
    }

    static String shortName(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        return fullType.substring(p + 1);
    }

    static String stripBrackets(String fullType) {
        return fullType.substring(1, fullType.length() - 1);
    }

    static String initCap(String input) {
        if (input.length() < 2) {
            return input.toUpperCase();
        }
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }

    static String escapeQuotes(String input) {
        return input.replaceAll("^\"|\"$", "\\\\\"");
    }

    static String initLower(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toLower = true;
        for (char ch : name.toCharArray()) {
            if (Character.isUpperCase(ch)) {
                if (toLower) {
                    sb.append(Character.toLowerCase(ch));
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
            toLower = false;
        }
        return sb.toString();
    }

    static String baseTypeOfAdapter(String adapterFullName) {
        TypeElement element = APContext.typeElement(adapterFullName);
        if (element == null) {
            throw new NullPointerException("Element not found for [" + adapterFullName + "]");
        }
        return Util.baseTypeOfAdapter(element);
    }

    static String baseTypeOfAdapter(TypeElement element) {
        return Optional.of(element.getSuperclass()).filter(t -> t.toString().contains("io.avaje.validation.adapter.AbstractConstraintAdapter") || t.toString().contains("io.avaje.validation.adapter.PrimitiveAdapter")).or(Util.validationAdapter(element)).map(UType::parse).map(UType::param0).map(UType::fullWithoutAnnotations).map(ProcessorUtils::extractEnclosingFQN).orElseGet(() -> {
            APContext.logError(element, "Custom Constraint adapters must extend AbstractConstraintAdapter or implement ValidationAdapter", new Object[0]);
            return "Invalid";
        });
    }

    static boolean isPrimitiveAdapter(TypeElement element) {
        return Optional.of(element.getSuperclass()).filter(t -> t.toString().contains("io.avaje.validation.adapter.PrimitiveAdapter")).or(Util.primitiveAdapter(element)).isPresent();
    }

    private static Supplier<Optional<? extends TypeMirror>> validationAdapter(TypeElement element) {
        return () -> element.getInterfaces().stream().filter(t -> t.toString().contains("io.avaje.validation.adapter.ValidationAdapter") || t.toString().contains("io.avaje.validation.adapter.ValidationAdapter.Primitive")).findFirst();
    }

    private static Supplier<Optional<? extends TypeMirror>> primitiveAdapter(TypeElement element) {
        return () -> element.getInterfaces().stream().filter(t -> t.toString().contains("io.avaje.validation.adapter.ValidationAdapter.Primitive")).findFirst();
    }

    static boolean isBasicType(String topType) {
        return BASIC_TYPES.contains(topType) || topType.startsWith("java.time.") || GenericTypeMap.typeOfRaw(topType) != null;
    }
}

