/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.AdapterHelper;
import io.avaje.validation.generator.Append;
import io.avaje.validation.generator.ElementAnnotationContainer;
import io.avaje.validation.generator.ProcessingContext;
import io.avaje.validation.generator.UType;
import io.avaje.validation.generator.Util;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

final class ValidMethodReader {
    private final ExecutableElement methodElement;
    private final String type;
    private final Set<String> importTypes = new TreeSet<String>();
    private final List<? extends VariableElement> params;
    private final List<ElementAnnotationContainer> paramAnnotations;
    private final ElementAnnotationContainer returnElementAnnotation;

    ValidMethodReader(ExecutableElement element) {
        this.methodElement = element;
        this.type = element.getEnclosingElement().toString();
        this.params = element.getParameters();
        this.importTypes.add(this.type);
        this.importTypes.add("java.util.List");
        this.importTypes.add(ProcessingContext.diAnnotation());
        this.importTypes.add("java.util.Set");
        this.importTypes.add("java.util.Map");
        this.importTypes.add("io.avaje.validation.adapter.MethodAdapterProvider");
        this.importTypes.add("io.avaje.validation.adapter.ValidationAdapter");
        this.importTypes.add("io.avaje.validation.adapter.ValidationContext");
        this.importTypes.add("io.avaje.validation.spi.Generated");
        this.importTypes.add("java.lang.reflect.Method");
        this.paramAnnotations = this.params.stream().map(ElementAnnotationContainer::create).toList();
        this.returnElementAnnotation = ElementAnnotationContainer.create(element);
    }

    public String shortName() {
        return this.methodElement.getSimpleName().toString();
    }

    private Set<String> importTypes() {
        if (Util.validImportType(this.type)) {
            this.importTypes.add(this.type);
        }
        this.paramAnnotations.forEach(a -> a.addImports(this.importTypes));
        this.returnElementAnnotation.addImports(this.importTypes);
        return this.importTypes;
    }

    public void writeImports(Append writer) {
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType)) continue;
            writer.append("import %s;", importType).eol();
        }
        writer.eol();
    }

    public void writeValidatorMethod(Append writer) {
        writer.append("  @Override\n  public Method method() throws Exception {\n");
        writer.append("    return %s.class.getDeclaredMethod(\"%s\"", Util.shortName(this.type), this.methodElement.getSimpleName());
        String paramClasses = this.params.stream().map(VariableElement::asType).map(UType::parse).map(UType::mainType).map(Util::shortName).map(s -> s + ".class").collect(Collectors.joining(",")).transform(s -> s.endsWith(",") ? s.substring(0, s.length() - 1) : s).transform(s -> s.isBlank() ? s : ", " + s);
        writer.append(paramClasses);
        writer.append(");\n  }\n\n  @Override\n  public List<ValidationAdapter<Object>> paramAdapters(ValidationContext ctx) {\n");
        writer.append("    return List.of(");
        int size = this.paramAnnotations.size();
        for (int i = 0; i < this.paramAnnotations.size(); ++i) {
            new AdapterHelper(writer, this.paramAnnotations.get(i), "\n        ").write();
            if (i + 1 == size) continue;
            writer.append(",");
        }
        writer.append(");\n  }\n\n  @Override\n  public ValidationAdapter<Object> returnAdapter(ValidationContext ctx) {\n");
        writer.append("    return ");
        new AdapterHelper(writer, this.returnElementAnnotation, "").write();
        writer.append(";\n  }\n\n  @Override\n  public ValidationAdapter<Object[]> crossParamAdapter(ValidationContext ctx) {\n");
        writer.append("    return ");
        new AdapterHelper(writer, this.returnElementAnnotation, "", "Object[]", null, false, true).write();
        writer.append(";").eol();
        writer.append("  }").eol();
    }

    public ExecutableElement getBeanType() {
        return this.methodElement;
    }
}

