/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.validation.generator;

import io.avaje.validation.generator.APContext;
import io.avaje.validation.generator.AdapterName;
import io.avaje.validation.generator.BeanReader;
import io.avaje.validation.generator.ClassReader;
import io.avaje.validation.generator.ComponentMetaData;
import io.avaje.validation.generator.ComponentReader;
import io.avaje.validation.generator.ConstraintAdapterPrism;
import io.avaje.validation.generator.ConstraintPrism;
import io.avaje.validation.generator.ContraintReader;
import io.avaje.validation.generator.CrossParamConstraintPrism;
import io.avaje.validation.generator.ImportValidPojoPrism;
import io.avaje.validation.generator.ProcessingContext;
import io.avaje.validation.generator.ProcessorUtils;
import io.avaje.validation.generator.SimpleAdapterWriter;
import io.avaje.validation.generator.SimpleComponentWriter;
import io.avaje.validation.generator.SimpleParamBeanWriter;
import io.avaje.validation.generator.Util;
import io.avaje.validation.generator.ValidMethodReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"io.avaje.validation.constraints.Valid", "io.avaje.validation.ImportValidPojo", "io.avaje.http.api.Valid", "javax.validation.Valid", "jakarta.validation.Valid", "io.avaje.validation.adapter.ConstraintAdapter", "io.avaje.validation.constraints.Constraint", "jakarta.validation.Constraint", "javax.validation.Constraint", "io.avaje.validation.CrossParamConstraint", "io.avaje.validation.ValidMethod"})
public final class ValidationProcessor
extends AbstractProcessor {
    private final ComponentMetaData metaData = new ComponentMetaData();
    private final List<BeanReader> allReaders = new ArrayList<BeanReader>();
    private final Set<String> sourceTypes = new HashSet<String>();
    private final Set<String> mixInImports = new HashSet<String>();
    private final Set<String> alreadyGenerated = new HashSet<String>();
    private SimpleComponentWriter componentWriter;
    private boolean readModuleInfo;
    private boolean processedAnything;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        ProcessingContext.init(processingEnv);
        this.componentWriter = new SimpleComponentWriter(this.metaData);
    }

    private void readModule() {
        if (this.readModuleInfo) {
            return;
        }
        this.readModuleInfo = true;
        new ComponentReader(this.metaData).read();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        APContext.setProjectModuleElement(annotations, round);
        this.readModule();
        this.getElements(round, "io.avaje.validation.constraints.Constraint").ifPresent(this::writeConstraintAdapters);
        this.getElements(round, "javax.validation.Constraint").ifPresent(this::writeConstraintAdapters);
        this.getElements(round, "jakarta.validation.Constraint").ifPresent(this::writeConstraintAdapters);
        this.getElements(round, "io.avaje.validation.CrossParamConstraint").ifPresent(this::writeConstraintAdapters);
        this.getElements(round, "io.avaje.validation.adapter.ConstraintAdapter").ifPresent(this::registerCustomAdapters);
        this.getElements(round, "io.avaje.validation.constraints.Valid").ifPresent(this::writeAdapters);
        this.getElements(round, "io.avaje.http.api.Valid").ifPresent(this::writeAdapters);
        this.getElements(round, "javax.validation.Valid").ifPresent(this::writeAdapters);
        this.getElements(round, "jakarta.validation.Valid").ifPresent(this::writeAdapters);
        this.getElements(round, "io.avaje.validation.ValidMethod").map(ElementFilter::methodsIn).ifPresent(this::writeParamProviderForMethod);
        this.getElements(round, "io.avaje.validation.ImportValidPojo").ifPresent(this::writeAdaptersForImported);
        this.initialiseComponent();
        this.cascadeTypes();
        this.writeComponent(round.processingOver());
        return false;
    }

    private Optional<? extends Set<? extends Element>> getElements(RoundEnvironment round, String name) {
        return Optional.ofNullable(APContext.typeElement(name)).map(round::getElementsAnnotatedWith);
    }

    private void registerCustomAdapters(Set<? extends Element> elements) {
        for (TypeElement typeElement : ElementFilter.typesIn(elements)) {
            String type = Util.baseTypeOfAdapter(typeElement);
            TypeElement targetAnnotation = APContext.asTypeElement(ConstraintAdapterPrism.getInstanceOn(typeElement).value());
            if (!CrossParamConstraintPrism.getAllOnMetaAnnotations(typeElement).isEmpty() && type.contains("Object[]")) {
                APContext.logError(typeElement, "Cross Parameter Adapters must accept type Object[]", new Object[0]);
            }
            ConstraintPrism.getOptionalOn(targetAnnotation).ifPresent(p -> {
                if (p.unboxPrimitives().booleanValue() && !Util.isPrimitiveAdapter(typeElement)) {
                    if (ValidationProcessor.noPrimitiveValidateMethods(typeElement)) {
                        APContext.logError(typeElement, "Adapters for Primitive Constraints must override a primitive \"isValid\" or \"validate\" method", new Object[0]);
                    }
                    APContext.logError(typeElement, "Adapters for Primitive Constraints must extend PrimitiveAdapter or implement ValidationAdapter.Primitive", new Object[0]);
                }
            });
            ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(m -> m.getModifiers().contains((Object)Modifier.PUBLIC)).filter(m -> m.getParameters().size() == 1).map(m -> m.getParameters().get(0).asType().toString()).map(ProcessorUtils::trimAnnotations).filter("io.avaje.validation.adapter.ValidationContext.AdapterCreateRequest"::equals).findAny().ifPresentOrElse(x -> {}, () -> APContext.logError(typeElement, "Custom Adapters must have a public constructor with a single AdapterCreateRequest parameter", new Object[0]));
            this.metaData.addAnnotationAdapter(typeElement);
        }
    }

    private static boolean noPrimitiveValidateMethods(TypeElement typeElement) {
        return ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(m -> "isValid".equals(m.getSimpleName().toString()) || "validate".equals(m.getSimpleName().toString())).toList().size() < 2;
    }

    private void cascadeTypes() {
        while (!this.allReaders.isEmpty()) {
            this.cascadeTypesInner();
        }
    }

    private void cascadeTypesInner() {
        ArrayList<BeanReader> copy = new ArrayList<BeanReader>(this.allReaders);
        this.allReaders.clear();
        TreeSet<String> extraTypes = new TreeSet<String>();
        for (BeanReader reader : copy) {
            reader.cascadeTypes(extraTypes);
        }
        for (String type : extraTypes) {
            TypeElement element;
            if (this.ignoreType(type) || !this.cascadeElement(element = APContext.typeElement(type))) continue;
            this.writeAdapterForType(element);
        }
    }

    private boolean cascadeElement(TypeElement element) {
        return element != null && element.getKind() != ElementKind.ENUM && !this.metaData.contains(this.adapterName(element));
    }

    private String adapterName(TypeElement element) {
        return new AdapterName(element).fullName();
    }

    private boolean ignoreType(String type) {
        return type.indexOf(46) == -1 || type.startsWith("java.") || type.startsWith("javax.") || this.sourceTypes.contains(type);
    }

    private void writeAdaptersForImported(Set<? extends Element> importedElements) {
        for (TypeElement importedElement : ElementFilter.typesIn(importedElements)) {
            for (TypeMirror importType : ImportValidPojoPrism.getInstanceOn(importedElement).value()) {
                if (this.mixInImports.contains(importType.toString())) continue;
                this.writeAdapterForType(APContext.asTypeElement(importType));
            }
        }
    }

    private void initialiseComponent() {
        if (!this.processedAnything) {
            return;
        }
        this.metaData.initialiseFullName();
        try {
            this.componentWriter.initialise();
        }
        catch (IOException e) {
            APContext.logError("Error creating writer for ValidationComponent", e);
        }
    }

    private void writeComponent(boolean processingOver) {
        if (processingOver && this.processedAnything) {
            try {
                this.componentWriter.write();
                this.componentWriter.writeMetaInf();
            }
            catch (IOException e) {
                APContext.logError("Error writing component", e);
            }
            finally {
                ProcessingContext.clear();
            }
        }
    }

    private void writeAdapters(Set<? extends Element> beans) {
        ElementFilter.typesIn(beans).forEach(this::writeAdapterForType);
    }

    private void writeConstraintAdapters(Set<? extends Element> beans) {
        ElementFilter.typesIn(beans).stream().filter(type -> type.getAnnotationMirrors().stream().anyMatch(m -> ConstraintPrism.isPresent(m.getAnnotationType().asElement()))).forEach(this::writeAdapterForConstraint);
    }

    private void writeAdapterForType(TypeElement typeElement) {
        if (this.isController(typeElement) || !this.alreadyGenerated.add(typeElement.getQualifiedName().toString())) {
            return;
        }
        ClassReader beanReader = new ClassReader(typeElement);
        this.writeAdapter(typeElement, beanReader);
    }

    private boolean isController(TypeElement typeElement) {
        return typeElement.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).map(TypeMirror::toString).anyMatch(val -> val.endsWith(".Controller"));
    }

    private void writeAdapterForConstraint(TypeElement typeElement) {
        if (ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().noneMatch(m -> "message".equals(m.getSimpleName().toString()))) {
            APContext.logError(typeElement, "Constraint annotations must contain a message method", new Object[0]);
        }
        ContraintReader beanReader = new ContraintReader(typeElement);
        this.writeAdapter(typeElement, beanReader);
    }

    private void writeAdapter(TypeElement typeElement, BeanReader beanReader) {
        this.processedAnything = true;
        beanReader.read();
        if (beanReader.nonAccessibleField()) {
            if (beanReader.hasValidationAnnotation()) {
                APContext.logError("Error ValidationAdapter due to nonAccessibleField for %s ", beanReader);
            }
            return;
        }
        try {
            SimpleAdapterWriter beanWriter = new SimpleAdapterWriter(beanReader);
            if (beanReader instanceof ClassReader) {
                this.metaData.add(beanWriter.fullName());
            }
            beanWriter.write();
            this.allReaders.add(beanReader);
            this.sourceTypes.add(typeElement.getSimpleName().toString());
        }
        catch (IOException e) {
            APContext.logError("Error writing ValidationAdapter for %s %s", beanReader, e);
        }
    }

    private void writeParamProviderForMethod(Set<ExecutableElement> elements) {
        for (ExecutableElement executableElement : elements) {
            if (executableElement.getEnclosingElement().getAnnotationMirrors().stream().map(m -> m.getAnnotationType().toString()).noneMatch(ValidationProcessor::isInjectableComponent)) {
                APContext.logError(executableElement, "The ValidMethod Annotation can only be used with JSR-330 Injectable Classes", new Object[0]);
            }
            this.writeParamProvider(executableElement);
        }
    }

    private static boolean isInjectableComponent(String annotationType) {
        return annotationType.contains("Singleton") || annotationType.contains("Component") || annotationType.contains("Service") || annotationType.contains("Controller");
    }

    private void writeParamProvider(ExecutableElement typeElement) {
        ValidMethodReader beanReader = new ValidMethodReader(typeElement);
        try {
            SimpleParamBeanWriter beanWriter = new SimpleParamBeanWriter(beanReader);
            beanWriter.write();
        }
        catch (IOException e) {
            APContext.logError("Error writing ValidationAdapter for %s %s", beanReader, e);
        }
    }
}

