package io.avaje.validation.generator;

import static java.util.stream.Collectors.*;
import java.util.stream.Stream;
import javax.lang.model.type.DeclaredType;
import java.util.Set;
import java.util.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Map;
import javax.annotation.processing.Generated;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import java.util.HashMap;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

/** A Prism representing a {@link javax.validation.constraints.Email @Email} annotation. */ 
@Generated("avaje-prism-generator")
final class JavaxEmailPrism implements io.avaje.validation.generator.PatternPrism {
  /** store prism value of message */
  private final String _message;

  /** store prism value of groups */
  private final List<TypeMirror> _groups;

  /** store prism value of payload */
  private final List<TypeMirror> _payload;

  /** store prism value of regexp */
  private final String _regexp;

  /** store prism value of flags */
  private final List<String> _flags;

  public static final String PRISM_TYPE = "javax.validation.constraints.Email";

  /**
   * An instance of the Values inner class whose
   * methods return the AnnotationValues used to build this prism. 
   * Primarily intended to support using Messager.
   */
  final Values values;

  /** Returns true if the mirror is an instance of {@link javax.validation.constraints.Email @Email} is present on the element, else false.
   *
   * @param mirror mirror. 
   * @return true if prism is present. 
   */
  static boolean isInstance(AnnotationMirror mirror) {
    return getInstance(mirror) != null;
  }

  /** Returns true if {@link javax.validation.constraints.Email @Email} is present on the element, else false.
   *
   * @param element element. 
   * @return true if annotation is present on the element. 
   */
  static boolean isPresent(Element element) {
    return getInstanceOn(element) != null;
  }

  /** Return a prism representing the {@link javax.validation.constraints.Email @Email} annotation present on the given element. 
   * similar to {@code element.getAnnotation(Email.class)} except that 
   * an instance of this class rather than an instance of {@link javax.validation.constraints.Email @Email}
   * is returned.
   *
   * @param element element. 
   * @return prism on element or null if no annotation is found. 
   */
  static JavaxEmailPrism getInstanceOn(Element element) {
    final var mirror = getMirror(element);
    if (mirror == null) return null;
    return getInstance(mirror);
  }

  /** Return a Optional representing a nullable {@link javax.validation.constraints.Email @Email} annotation on the given element. 
   * similar to {@code element.getAnnotation(javax.validation.constraints.Email.class)} except that 
   * an Optional of this class rather than an instance of {@link javax.validation.constraints.Email}
   * is returned.
   *
   * @param element element. 
   * @return prism optional for element. 
   */
  static Optional<JavaxEmailPrism> getOptionalOn(Element element) {
    final var mirror = getMirror(element);
    if (mirror == null) return Optional.empty();
    return getOptional(mirror);
  }

  /** Return a list of prisms representing the {@link javax.validation.constraints.Email @Email} annotation on 'e'. 
   * similar to {@code e.getAnnotationsByType(javax.validation.constraints.Email.class)} except that 
   * instances of this class rather than instances of {@link javax.validation.constraints.Email}
   * is returned.
   *
   * @param element element. 
   * @return list of prisms on the element. 
   */
  static List<JavaxEmailPrism> getAllInstancesOn(Element element) {
    return getMirrors(element)
        .map(JavaxEmailPrism::getInstance)
        .collect(toList());
  }

  /** Return a list of prisms representing the {@link javax.validation.constraints.Email @Email} meta annotation on all the annotations on the given element. 
   * this method will recursively search all the annotations on the element. 
   *
   * @param element element. 
   * @return list of prisms on the element's annotation. 
   */
  static List<JavaxEmailPrism> getAllOnMetaAnnotations(Element element) {
    if (element == null || element.getAnnotationMirrors().isEmpty()) return List.of();

    //use a hashset to keep track of seen annotations 
    return getAllOnMetaAnnotations(element, new HashSet<>()).collect(toList());
  }

  /** Recursively search annotation elements for prisms.
   * Uses a set to keep track of known annotations to avoid repeats/recursive loop. 
   *
   * @param element element. 
   * @param seen set that tracks seen elements. 
   * @return stream of prisms on the element's annotation. 
   */
  private static Stream<JavaxEmailPrism> getAllOnMetaAnnotations(Element element, Set<String> seen) {
    if (element == null || element.getAnnotationMirrors().isEmpty()) return Stream.of();

    return element.getAnnotationMirrors().stream()
      .map(AnnotationMirror::getAnnotationType)
      //only search annotations 
      .filter(t -> seen.add(t.toString()))
        .map(DeclaredType::asElement)
        .flatMap(
            e ->
                Stream.concat(
                    getAllOnMetaAnnotations(e, seen),
                    getMirrors(element).map(JavaxEmailPrism::getInstance)));
  }

  /** Return a prism of the {@link javax.validation.constraints.Email @Email} annotation from an annotation mirror. 
   *
   * @param mirror mirror. 
   * @return prism for mirror or null if mirror is an incorrect type. 
   */
  static JavaxEmailPrism getInstance(AnnotationMirror mirror) {
    if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) return null;

    return new JavaxEmailPrism(mirror);
  }

  /** Return an Optional representing a nullable {@link JavaxEmailPrism @JavaxEmailPrism} from an annotation mirror. 
   * similar to {@code e.getAnnotation(javax.validation.constraints.Email.class)} except that 
   * an Optional of this class rather than an instance of {@link javax.validation.constraints.Email @Email}
   * is returned.
   *
   * @param mirror mirror. 
   * @return prism optional for mirror. 
   */
  static Optional<JavaxEmailPrism> getOptional(AnnotationMirror mirror) {
    if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) return Optional.empty();

    return Optional.of(new JavaxEmailPrism(mirror));
  }

  private JavaxEmailPrism(AnnotationMirror mirror) {
    for (final ExecutableElement key : mirror.getElementValues().keySet()) {
      memberValues.put(key.getSimpleName().toString(), mirror.getElementValues().get(key));
    }
    for (final ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
      defaults.put(member.getSimpleName().toString(), member.getDefaultValue());
    }
    _message = getValue("message", String.class);
    _groups = getArrayValues("groups", TypeMirror.class);
    _payload = getArrayValues("payload", TypeMirror.class);
    _regexp = getValue("regexp", String.class);
    List<VariableElement> flagsMirrors = getArrayValues("flags", VariableElement.class);
     _flags = new ArrayList<String>(flagsMirrors.size());
    for(VariableElement flagsMirror : flagsMirrors) {
        _flags.add(flagsMirror.getSimpleName().toString());
    }
    this.values = new Values(memberValues);
    this.mirror = mirror;
    this.isValid = valid;
  }

  /** 
   * Returns a String representing the value of the {@code java.lang.String message()} member of the Annotation.
   * @see javax.validation.constraints.Email#message()
   */ 
  public String message() { return _message; }

  /** 
   * Returns a List&lt;TypeMirror&gt; representing the value of the {@code groups()} member of the Annotation.
   * @see javax.validation.constraints.Email#groups()
   */ 
  public List<TypeMirror> groups() { return _groups; }

  /** 
   * Returns a List&lt;TypeMirror&gt; representing the value of the {@code payload()} member of the Annotation.
   * @see javax.validation.constraints.Email#payload()
   */ 
  public List<TypeMirror> payload() { return _payload; }

  /** 
   * Returns a String representing the value of the {@code java.lang.String regexp()} member of the Annotation.
   * @see javax.validation.constraints.Email#regexp()
   */ 
  public String regexp() { return _regexp; }

  /** 
   * Returns a List&lt;String&gt; representing the value of the {@code flags()} member of the Annotation.
   * @see javax.validation.constraints.Email#flags()
   */ 
  public List<String> flags() { return _flags; }

  /**
   * Determine whether the underlying AnnotationMirror has no errors.
   * True if the underlying AnnotationMirror has no errors.
   * When true is returned, none of the methods will return null.
   * When false is returned, a least one member will either return null, or another
   * prism that is not valid.
   */
   final boolean isValid;
    
  /**
   * The underlying AnnotationMirror of the annotation
   * represented by this Prism. 
   * Primarily intended to support using Messager.
   */
   final AnnotationMirror mirror;
  /**
   * A class whose members correspond to those of {@link javax.validation.constraints.Email @Email} 
   * but which each return the AnnotationValue corresponding to
   * that member in the model of the annotations. Returns null for
   * defaulted members. Used for Messager, so default values are not useful.
   */
  static final class Values {
    private final Map<String, AnnotationValue> values;

    private Values(Map<String, AnnotationValue> values) {
      this.values = values;
    }    
    /** Return the AnnotationValue corresponding to the message() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue message(){ return values.get("message");}
    /** Return the AnnotationValue corresponding to the groups() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue groups(){ return values.get("groups");}
    /** Return the AnnotationValue corresponding to the payload() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue payload(){ return values.get("payload");}
    /** Return the AnnotationValue corresponding to the regexp() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue regexp(){ return values.get("regexp");}
    /** Return the AnnotationValue corresponding to the flags() 
     * member of the annotation, or null when the default value is implied.
     */
    AnnotationValue flags(){ return values.get("flags");}
  }

  private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
  private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
  private boolean valid = true;

  private <T> T getValue(String name, Class<T> clazz) {
    final T result = JavaxEmailPrism.getValue(memberValues, defaults, name, clazz);
    if (result == null) valid = false;
    return result;
  }

  private <T> List<T> getArrayValues(String name, final Class<T> clazz) {
    final List<T> result = JavaxEmailPrism.getArrayValues(memberValues, defaults, name, clazz);
    if (result == null) valid = false;
    return result;
  }
  private static AnnotationMirror getMirror(Element target) {
    for (final var m : target.getAnnotationMirrors()) {
      final CharSequence mfqn = ((TypeElement) m.getAnnotationType().asElement()).getQualifiedName();
      if (PRISM_TYPE.contentEquals(mfqn)) return m;
    }
    return null;
  }

  private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
    return target.getAnnotationMirrors().stream()
        .filter(
             m -> PRISM_TYPE.contentEquals(((TypeElement) m.getAnnotationType().asElement()).getQualifiedName()));
  }

  private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
    AnnotationValue av = memberValues.get(name);
    if (av == null) av = defaults.get(name);
    if (av == null) {
      return null;
    }
    if (clazz.isInstance(av.getValue())) return clazz.cast(av.getValue());
    return null;
  }

  private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, final Class<T> clazz) {
    AnnotationValue av = memberValues.get(name);
    if (av == null) av = defaults.get(name);
    if (av == null) {
      return List.of();
    }
    if (av.getValue() instanceof List) {
      final List<T> result = new ArrayList<>();
      for (final var v : getValueAsList(av)) {
        if (clazz.isInstance(v.getValue())) {
          result.add(clazz.cast(v.getValue()));
        } else {
          return List.of();
        }
      }
      return result;
    } else {
      return List.of();
    }
  }

  @SuppressWarnings("unchecked")
  private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
    return (List<AnnotationValue>) av.getValue();
  }
}
