/*
 * Decompiled with CFR 0.152.
 */
package io.axual.security.auth;

import io.axual.util.PrincipalBuilderUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.message.DefaultPrincipalData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslPrincipalBuilder
implements KafkaPrincipalBuilder,
KafkaPrincipalSerde {
    private static final Logger log = LoggerFactory.getLogger(SslPrincipalBuilder.class);

    public KafkaPrincipal convertToCustomPrincipal(SSLSession sslSession) {
        try {
            Certificate[] chain = sslSession.getPeerCertificates();
            if (chain != null && chain.length > 0) {
                return new KafkaPrincipal("User", PrincipalBuilderUtil.buildAdvancedPrincipalChain((Certificate[])chain));
            }
            return KafkaPrincipal.ANONYMOUS;
        }
        catch (IOException in) {
            log.error("Something went wrong in convertToCustomPrincipal", (Throwable)in);
            return KafkaPrincipal.ANONYMOUS;
        }
    }

    public KafkaPrincipal build(AuthenticationContext context) {
        if (context instanceof PlaintextAuthenticationContext) {
            return KafkaPrincipal.ANONYMOUS;
        }
        if (context instanceof SslAuthenticationContext) {
            SSLSession sslSession = ((SslAuthenticationContext)context).session();
            return this.convertToCustomPrincipal(sslSession);
        }
        if (context instanceof SaslAuthenticationContext) {
            SaslServer saslServer = ((SaslAuthenticationContext)context).server();
            if ("GSSAPI".equals(saslServer.getMechanismName())) {
                throw new IllegalArgumentException("Unhandled authentication context type: " + context.getClass().getName());
            }
            return new KafkaPrincipal("User", saslServer.getAuthorizationID());
        }
        throw new IllegalArgumentException("Unhandled authentication context type: " + context.getClass().getName());
    }

    public byte[] serialize(KafkaPrincipal principal) throws SerializationException {
        DefaultPrincipalData data = new DefaultPrincipalData().setType(principal.getPrincipalType()).setName(principal.getName()).setTokenAuthenticated(principal.tokenAuthenticated());
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)data);
    }

    public KafkaPrincipal deserialize(byte[] bytes) throws SerializationException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        short version = buffer.getShort();
        if (version < 0 || version > 0) {
            throw new SerializationException("Invalid principal data version " + version);
        }
        DefaultPrincipalData data = new DefaultPrincipalData((Readable)new ByteBufferAccessor(buffer), version);
        return new KafkaPrincipal(data.type(), data.name(), data.tokenAuthenticated());
    }
}

