/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.logging.core;

import io.axual.client.proxy.callback.core.MethodCall;
import io.axual.client.proxy.callback.core.MethodCallFactory;
import io.axual.client.proxy.logging.core.DebugLogger;
import io.axual.client.proxy.logging.core.ErrorLogger;
import io.axual.client.proxy.logging.core.InfoLogger;
import io.axual.client.proxy.logging.core.LevelLogger;
import io.axual.client.proxy.logging.core.LogLevel;
import io.axual.client.proxy.logging.core.LoggingConfig;
import io.axual.client.proxy.logging.core.LoggingMethodCall;
import io.axual.client.proxy.logging.core.TraceLogger;
import io.axual.client.proxy.logging.core.WarnLogger;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMethodCallFactory
implements MethodCallFactory {
    private final LevelLogger log;
    private final LoggingConfig config;

    public LoggingMethodCallFactory(LoggingConfig config, Class logClass) {
        this.config = config;
        this.log = this.getLogger(config.getLevel(), logClass);
    }

    private LevelLogger getLogger(LogLevel level, Class logClass) {
        Logger logger = LoggerFactory.getLogger((String)logClass.getName());
        switch (level) {
            case TRACE: {
                return new TraceLogger(logger);
            }
            case DEBUG: {
                return new DebugLogger(logger);
            }
            case INFO: {
                return new InfoLogger(logger);
            }
            case WARN: {
                return new WarnLogger(logger);
            }
            case ERROR: {
                return new ErrorLogger(logger);
            }
        }
        return new InfoLogger(logger);
    }

    @Override
    public MethodCall create(UUID callId, Object object, String method) {
        return new LoggingMethodCall(this.config, this.log, callId, method);
    }
}

