/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.admin;

import io.axual.common.resolver.TopicResolver;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ExtendableCreateTopicsResult;
import org.apache.kafka.common.KafkaFuture;

public class ResolvingCreateTopicsResult
extends ExtendableCreateTopicsResult {
    private final TopicResolver topicResolver;
    final Map<String, KafkaFuture<Void>> values;

    ResolvingCreateTopicsResult(CreateTopicsResult result, TopicResolver resolver) {
        super(result);
        this.topicResolver = resolver;
        this.values = new HashMap<String, KafkaFuture<Void>>();
        result.values().forEach((k, v) -> this.values.put(this.topicResolver.unresolveTopic(k), (KafkaFuture<Void>)v));
    }

    @Override
    public Map<String, KafkaFuture<Void>> values() {
        return this.values;
    }

    @Override
    public KafkaFuture<Config> config(String topic) {
        return super.config(this.topicResolver.resolveTopic(topic));
    }

    @Override
    public KafkaFuture<Integer> numPartitions(String topic) {
        return super.numPartitions(this.topicResolver.resolveTopic(topic));
    }

    @Override
    public KafkaFuture<Integer> replicationFactor(String topic) {
        return super.replicationFactor(this.topicResolver.resolveTopic(topic));
    }
}

