/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.consumer;

import io.axual.client.proxy.generic.consumer.ConsumerProxy;
import io.axual.client.proxy.resolving.consumer.ResolvingConsumerPartitionAssignor;
import io.axual.client.proxy.resolving.generic.ResolvingClientProxyConfig;
import io.axual.common.resolver.GroupResolver;
import java.util.Map;

public class ResolvingConsumerConfig<K, V>
extends ResolvingClientProxyConfig<ConsumerProxy<K, V>> {
    public static final String BACKING_FACTORY_CONFIG = "resolvingconsumer.backing.factory";
    public static final String GROUP_ID_RESOLVER_CONFIG = "group.id.resolver";
    private final GroupResolver groupResolver;

    ResolvingConsumerConfig(Map<String, Object> configs) {
        super(configs, BACKING_FACTORY_CONFIG);
        this.filterDownstream(new String[]{GROUP_ID_RESOLVER_CONFIG});
        this.groupResolver = (GroupResolver)this.getConfiguredInstance(GROUP_ID_RESOLVER_CONFIG, GroupResolver.class);
        this.groupResolver.configure(configs);
        String groupId = this.parseAndFilterStringConfig("group.id", true, null);
        this.putDownstream("group.id", this.groupResolver.resolveGroup(groupId));
        if (configs.containsKey("partition.assignment.strategy")) {
            this.putDownstream("resolvingconsumerpartitionassignor.backing.assignor", configs.get("partition.assignment.strategy"));
            this.putDownstream("resolvingconsumerpartitionassignor.topic.resolver", this.getTopicResolver());
            this.putDownstream("partition.assignment.strategy", ResolvingConsumerPartitionAssignor.class.getName());
        }
    }

    public GroupResolver getGroupResolver() {
        return this.groupResolver;
    }
}

