/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.producer;

import io.axual.client.proxy.generic.producer.ExtendedProducerRecord;
import io.axual.client.proxy.generic.producer.StaticProducerProxy;
import io.axual.client.proxy.generic.tools.SerdeUtil;
import io.axual.client.proxy.resolving.producer.ResolvingProducerConfig;
import io.axual.common.resolver.TopicResolver;
import io.axual.common.tools.MapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.serialization.Serializer;

public class ResolvingProducer<K, V>
extends StaticProducerProxy<K, V, ResolvingProducerConfig<K, V>> {
    public ResolvingProducer(Map<String, Object> configs) {
        super(new ResolvingProducerConfig(configs));
    }

    public ResolvingProducer(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(SerdeUtil.addSerializersToConfigs(configs, keySerializer, valueSerializer));
    }

    public ResolvingProducer(Properties properties) {
        this(MapUtil.objectToStringMap((Map)properties));
    }

    public ResolvingProducer(Properties properties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(MapUtil.objectToStringMap((Map)properties), keySerializer, valueSerializer);
    }

    private static RecordMetadata convertRecordMetadata(RecordMetadata input, String topic) {
        return new RecordMetadata(new TopicPartition(topic, input.partition()), input.offset(), 0L, input.timestamp(), null, input.serializedKeySize(), input.serializedValueSize());
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        HashMap<TopicPartition, OffsetAndMetadata> newOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            newOffsets.put(((ResolvingProducerConfig)this.config).getTopicResolver().resolveTopic(entry.getKey()), entry.getValue());
        }
        super.sendOffsetsToTransaction(newOffsets, ((ResolvingProducerConfig)this.config).getGroupResolver().resolveGroup(consumerGroupId));
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        HashMap<TopicPartition, OffsetAndMetadata> newOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            newOffsets.put(((ResolvingProducerConfig)this.config).getTopicResolver().resolveTopic(entry.getKey()), entry.getValue());
        }
        super.sendOffsetsToTransaction(newOffsets, new ConsumerGroupMetadata(((ResolvingProducerConfig)this.config).getGroupResolver().resolveGroup(groupMetadata.groupId()), groupMetadata.generationId(), groupMetadata.memberId(), groupMetadata.groupInstanceId()));
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        ProducerRecord<K, V> sentRecord = this.convertProducerRecord(record);
        Future<RecordMetadata> future = super.send(sentRecord);
        this.applyHeadersToOriginalRecord(record, sentRecord);
        return new ProxyFuture(future, record.topic());
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        if (callback == null) {
            return this.send(record);
        }
        ProducerRecord<K, V> sentRecord = this.convertProducerRecord(record);
        Future<RecordMetadata> future = super.send(sentRecord, new ProxyCallback(callback, record.topic()));
        this.applyHeadersToOriginalRecord(record, sentRecord);
        return new ProxyFuture(future, record.topic());
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        List<PartitionInfo> rawResult = super.partitionsFor(((ResolvingProducerConfig)this.config).getTopicResolver().resolveTopic(topic));
        ArrayList<PartitionInfo> result = new ArrayList<PartitionInfo>(rawResult.size());
        for (PartitionInfo info : rawResult) {
            result.add(new PartitionInfo(((ResolvingProducerConfig)this.config).getTopicResolver().unresolveTopic(info.topic()), info.partition(), info.leader(), info.replicas(), info.inSyncReplicas()));
        }
        return result;
    }

    private ProducerRecord<K, V> convertProducerRecord(ProducerRecord<K, V> record) {
        TopicResolver resolver = ((ResolvingProducerConfig)this.config).getTopicResolver();
        if (record instanceof ExtendedProducerRecord) {
            ExtendedProducerRecord extendedRecord = (ExtendedProducerRecord)record;
            resolver.configure(extendedRecord.context());
            return new ExtendedProducerRecord<Object, Object>(resolver.resolveTopic(record.topic()), record.partition(), record.timestamp(), record.key(), record.value(), (Iterable<Header>)record.headers(), extendedRecord.context());
        }
        return new ProducerRecord(resolver.resolveTopic(record.topic()), record.partition(), record.timestamp(), record.key(), record.value(), (Iterable)record.headers());
    }

    private void applyHeadersToOriginalRecord(ProducerRecord<K, V> original, ProducerRecord<K, V> sent) {
        if (original != sent && original instanceof ExtendedProducerRecord) {
            ((ExtendedProducerRecord)original).setHeaders(sent.headers());
        }
    }

    private static class ProxyFuture
    implements Future<RecordMetadata> {
        private final Future<RecordMetadata> future;
        private final String topic;

        ProxyFuture(Future<RecordMetadata> future, String topic) {
            this.future = future;
            this.topic = topic;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public RecordMetadata get() throws InterruptedException, ExecutionException {
            return ResolvingProducer.convertRecordMetadata(this.future.get(), this.topic);
        }

        @Override
        public RecordMetadata get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return ResolvingProducer.convertRecordMetadata(this.future.get(timeout, unit), this.topic);
        }
    }

    private static final class ProxyCallback
    implements Callback {
        private final Callback callback;
        private final String topic;

        ProxyCallback(Callback callback, String topic) {
            this.callback = callback;
            this.topic = topic;
        }

        public void onCompletion(RecordMetadata input, Exception e) {
            if (input != null) {
                this.callback.onCompletion(ResolvingProducer.convertRecordMetadata(input, this.topic), e);
            } else {
                this.callback.onCompletion(null, e);
            }
        }
    }
}

