/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.switching.consumer;

import io.axual.client.proxy.generic.consumer.ConsumerProxy;
import io.axual.client.proxy.generic.tools.SerdeUtil;
import io.axual.client.proxy.switching.consumer.ConsumerSwitcher;
import io.axual.client.proxy.switching.consumer.Subscription;
import io.axual.client.proxy.switching.consumer.SwitchingConsumerConfig;
import io.axual.client.proxy.switching.consumer.TopicPartitionSetAssignment;
import io.axual.client.proxy.switching.consumer.TopicPatternSubscription;
import io.axual.client.proxy.switching.consumer.TopicSetSubscription;
import io.axual.client.proxy.switching.discovery.DiscoverySubscriber;
import io.axual.client.proxy.switching.generic.SwitchingProxy;
import io.axual.common.concurrent.LockedObject;
import io.axual.common.tools.MapUtil;
import io.axual.discovery.client.tools.DiscoveryConfigParserV2;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchingConsumer<K, V>
extends SwitchingProxy<ConsumerProxy<K, V>, SwitchingConsumerConfig<K, V>>
implements ConsumerProxy<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(SwitchingConsumer.class);
    private Set<TopicPartition> pausedPartitions = new HashSet<TopicPartition>();

    public SwitchingConsumer(Map<String, Object> configs) {
        super(new SwitchingConsumerConfig(configs), new DiscoverySubscriber(new DiscoveryConfigParserV2().parse(configs), SwitchingConsumer.class.getSimpleName(), new ConsumerSwitcher(), false));
    }

    public SwitchingConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(SerdeUtil.addDeserializersToConfigs(configs, keyDeserializer, valueDeserializer));
    }

    public SwitchingConsumer(Properties properties) {
        this(MapUtil.objectToStringMap((Map)properties));
    }

    public SwitchingConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(MapUtil.objectToStringMap((Map)properties), keyDeserializer, valueDeserializer);
    }

    public Set<TopicPartition> assignment() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Set set = ((ConsumerProxy)lock.object).assignment();
            return set;
        }
    }

    public Set<String> subscription() {
        Subscription<K, V> subscription = this.getConsumerSwitcher().getSubscription();
        if (subscription instanceof TopicSetSubscription) {
            Collection<String> topics = ((TopicSetSubscription)subscription).getTopics();
            HashSet<String> result = new HashSet<String>(topics.size());
            result.addAll(topics);
            return result;
        }
        return Collections.emptySet();
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        if (this.getConsumerSwitcher().getAssignment() != null) {
            this.operationNotSupported("topic set subscription when manual partition assignment is active");
        }
        if (topics == null || topics.isEmpty()) {
            this.unsubscribe();
            return;
        }
        try (LockedObject.ReadLock lock = this.getReadLock();){
            LOG.info("Subscribing to topics: {}", topics);
            this.getConsumerSwitcher().setSubscription((Consumer)lock.object, (SwitchingConsumerConfig)this.config, new TopicSetSubscription(topics, listener));
        }
    }

    public void subscribe(Collection<String> topics) {
        this.subscribe(topics, null);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        if (this.getConsumerSwitcher().getAssignment() != null) {
            this.operationNotSupported("pattern subscription when manual partition assignment is active");
        }
        if (pattern == null) {
            this.unsubscribe();
            return;
        }
        try (LockedObject.ReadLock lock = this.getReadLock();){
            LOG.info("Subscribing to pattern: {}", (Object)pattern);
            this.getConsumerSwitcher().setSubscription((Consumer)lock.object, (SwitchingConsumerConfig)this.config, new TopicPatternSubscription(pattern, listener));
        }
    }

    public void subscribe(Pattern pattern) {
        this.subscribe(pattern, null);
    }

    public void unsubscribe() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            this.getConsumerSwitcher().unsubscribe((Consumer)lock.object, (SwitchingConsumerConfig)this.config);
        }
    }

    public void assign(Collection<TopicPartition> partitions) {
        if (this.getConsumerSwitcher().getSubscription() != null) {
            this.operationNotSupported("manual partition assignment when a subscription is active");
        }
        try (LockedObject.ReadLock lock = this.getReadLock();){
            this.getConsumerSwitcher().setAssignment((Consumer)lock.object, (SwitchingConsumerConfig)this.config, new TopicPartitionSetAssignment(partitions));
        }
    }

    @Deprecated
    public ConsumerRecords<K, V> poll(long timeout) {
        this.maybeReplaceProxiedObject(false);
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ConsumerRecords consumerRecords = ((ConsumerProxy)lock.object).poll(timeout);
            return consumerRecords;
        }
    }

    public ConsumerRecords<K, V> poll(Duration timeout) {
        this.maybeReplaceProxiedObject(false);
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ConsumerRecords consumerRecords = ((ConsumerProxy)lock.object).poll(timeout);
            return consumerRecords;
        }
    }

    public void commitSync() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).commitSync();
        }
    }

    public void commitSync(Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).commitSync(timeout);
        }
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).commitSync(offsets);
        }
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).commitSync(offsets, timeout);
        }
    }

    public void commitAsync() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).commitAsync();
        }
    }

    public void commitAsync(OffsetCommitCallback callback) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).commitAsync(callback);
        }
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).commitAsync(offsets, callback);
        }
    }

    public void seek(TopicPartition partition, long offset) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).seek(partition, offset);
        }
    }

    public void seek(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).seek(topicPartition, offsetAndMetadata);
        }
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).seekToBeginning(partitions);
        }
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).seekToEnd(partitions);
        }
    }

    public long position(TopicPartition partition) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            long l = ((ConsumerProxy)lock.object).position(partition);
            return l;
        }
    }

    public long position(TopicPartition partition, Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            long l = ((ConsumerProxy)lock.object).position(partition, timeout);
            return l;
        }
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            OffsetAndMetadata offsetAndMetadata = ((ConsumerProxy)lock.object).committed(partition);
            return offsetAndMetadata;
        }
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            OffsetAndMetadata offsetAndMetadata = ((ConsumerProxy)lock.object).committed(partition, timeout);
            return offsetAndMetadata;
        }
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).committed(partitions);
            return map;
        }
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).committed(partitions, timeout);
            return map;
        }
    }

    public Map<MetricName, ? extends Metric> metrics() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).metrics();
            return map;
        }
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            List list = ((ConsumerProxy)lock.object).partitionsFor(topic);
            return list;
        }
    }

    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            List list = ((ConsumerProxy)lock.object).partitionsFor(topic, timeout);
            return list;
        }
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).listTopics();
            return map;
        }
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).listTopics(timeout);
            return map;
        }
    }

    public void pause(Collection<TopicPartition> partitions) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            this.pausedPartitions.addAll(partitions);
            ((ConsumerProxy)lock.object).pause(partitions);
        }
    }

    public void resume(Collection<TopicPartition> partitions) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).resume(partitions);
            this.pausedPartitions.removeAll(partitions);
        }
    }

    public Set<TopicPartition> paused() {
        return new HashSet<TopicPartition>(this.pausedPartitions);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).offsetsForTimes(timestampsToSearch);
            return map;
        }
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).offsetsForTimes(timestampsToSearch, timeout);
            return map;
        }
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).beginningOffsets(partitions);
            return map;
        }
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).beginningOffsets(partitions, timeout);
            return map;
        }
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).endOffsets(partitions);
            return map;
        }
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ConsumerProxy)lock.object).endOffsets(partitions, timeout);
            return map;
        }
    }

    public ConsumerGroupMetadata groupMetadata() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ConsumerGroupMetadata consumerGroupMetadata = ((ConsumerProxy)lock.object).groupMetadata();
            return consumerGroupMetadata;
        }
    }

    public void enforceRebalance() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).enforceRebalance();
        }
    }

    public void wakeup() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ConsumerProxy)lock.object).wakeup();
        }
    }

    private ConsumerSwitcher<K, V> getConsumerSwitcher() {
        return (ConsumerSwitcher)this.getSwitcher();
    }
}

