/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.switching.discovery;

import io.axual.client.proxy.generic.client.ClientProxy;
import io.axual.client.proxy.generic.client.ClientProxyReplacer;
import io.axual.client.proxy.generic.config.BaseClientProxyConfig;
import io.axual.client.proxy.switching.generic.ClientProxySwitcher;
import io.axual.common.exception.ClientException;
import io.axual.discovery.client.DiscoveryClient;
import io.axual.discovery.client.DiscoveryClientRegistry;
import io.axual.discovery.client.DiscoveryConfig;
import io.axual.discovery.client.DiscoveryResult;
import io.axual.discovery.client.exception.DiscoveryClientRegistrationException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverySubscriber<T extends ClientProxy, C extends BaseClientProxyConfig>
implements ClientProxyReplacer<T, C>,
DiscoveryClient {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoverySubscriber.class);
    private final DiscoveryConfig config;
    private final String clientType;
    private final ClientProxySwitcher<T, C> switcher;
    private final boolean allowNoTarget;
    private boolean needToSwitch = false;
    private DiscoveryResult newDiscoveryResult;
    private DiscoveryResult currentDiscoveryResult;

    public DiscoverySubscriber(DiscoveryConfig config, String clientType, ClientProxySwitcher<T, C> switcher, boolean allowNoTarget) {
        this.config = config;
        this.clientType = clientType;
        this.switcher = switcher;
        this.allowNoTarget = allowNoTarget;
        try {
            DiscoveryClientRegistry.register((DiscoveryConfig)this.config, (DiscoveryClient)this);
        }
        catch (DiscoveryClientRegistrationException e) {
            throw new ClientException("Discovery Client Registration failed for " + clientType, (Throwable)e);
        }
        if (this.newDiscoveryResult == null) {
            throw new ClientException("Could not initialize DiscoveryResult for " + clientType + " in " + this.getClass().getName());
        }
    }

    public ClientProxySwitcher<T, C> getSwitcher() {
        return this.switcher;
    }

    public void checkDiscovery() {
        DiscoveryClientRegistry.checkProperties((DiscoveryConfig)this.config);
    }

    @Override
    public void close() {
        DiscoveryClientRegistry.unregister((DiscoveryConfig)this.config, (DiscoveryClient)this);
    }

    public void onDiscoveryPropertiesChange(DiscoveryResult discoveryResult) {
        String newCluster;
        LOG.info("Received new DiscoveryResult for {}: {}", (Object)this.clientType, (Object)discoveryResult);
        if (discoveryResult == null && !this.allowNoTarget) {
            LOG.info("Empty target received, ignoring");
            return;
        }
        String currentCluster = this.currentDiscoveryResult != null ? this.currentDiscoveryResult.getCluster() : null;
        String string = newCluster = discoveryResult != null ? discoveryResult.getCluster() : null;
        if (!Objects.equals(currentCluster, newCluster)) {
            LOG.info("Switching {} from {} to {}", new Object[]{this.clientType, currentCluster, newCluster});
            this.newDiscoveryResult = discoveryResult;
            this.needToSwitch = true;
        } else {
            this.currentDiscoveryResult = discoveryResult;
        }
    }

    @Override
    public boolean needToReplace() {
        return this.needToSwitch;
    }

    @Override
    public T replace(T oldProxy, C config) {
        this.needToSwitch = false;
        DiscoveryResult oldDiscoveryResult = this.currentDiscoveryResult;
        this.currentDiscoveryResult = this.newDiscoveryResult;
        this.newDiscoveryResult = null;
        if (this.currentDiscoveryResult == null && !this.allowNoTarget) {
            LOG.error("New DiscoveryResult for {} can not be null upon switching!", (Object)this.clientType);
        }
        return this.switcher.switchProxy(oldProxy, config, oldDiscoveryResult, this.currentDiscoveryResult);
    }

    public DiscoveryResult getCurrentDiscoveryResult() {
        return this.currentDiscoveryResult;
    }

    public String getCurrentDiscoveryProperty(String key) {
        if (this.currentDiscoveryResult != null) {
            Object value = this.currentDiscoveryResult.getConfigs().get(key);
            return value instanceof String ? (String)value : null;
        }
        return null;
    }
}

