/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.switching.generic;

import io.axual.client.proxy.generic.client.ClientProxy;
import io.axual.client.proxy.generic.client.DynamicClientProxy;
import io.axual.client.proxy.switching.discovery.DiscoverySubscriber;
import io.axual.client.proxy.switching.exception.NoClusterAvailableException;
import io.axual.client.proxy.switching.generic.ClientProxySwitcher;
import io.axual.client.proxy.switching.generic.SwitchingProxyConfig;
import io.axual.common.concurrent.LockedObject;
import io.axual.discovery.client.DiscoveryResult;

public abstract class SwitchingProxy<T extends ClientProxy, C extends SwitchingProxyConfig>
extends DynamicClientProxy<T, C> {
    private final DiscoverySubscriber<T, C> subscriber;

    protected SwitchingProxy(C config, DiscoverySubscriber<T, C> subscriber) {
        super(config, subscriber);
        this.subscriber = subscriber;
    }

    protected ClientProxySwitcher<T, C> getSwitcher() {
        return this.subscriber.getSwitcher();
    }

    @Override
    protected synchronized boolean maybeReplaceProxiedObject(boolean force) {
        this.subscriber.checkDiscovery();
        return super.maybeReplaceProxiedObject(force);
    }

    @Override
    protected boolean maybeReplaceProxiedObject(boolean force, boolean isTransactional) {
        this.subscriber.checkDiscovery();
        return super.maybeReplaceProxiedObject(force, isTransactional);
    }

    @Override
    protected LockedObject.ReadLock getReadLock() {
        LockedObject.ReadLock result = super.getReadLock();
        if (result.object == null) {
            result.close();
            throw new NoClusterAvailableException();
        }
        return result;
    }

    protected DiscoveryResult getCurrentDiscoveryResult() {
        return this.subscriber.getCurrentDiscoveryResult();
    }

    protected String getDiscoveryProperty(String key) {
        return this.subscriber.getCurrentDiscoveryProperty(key);
    }
}

