/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.switching.producer;

import io.axual.client.proxy.generic.client.ClientProxyFactory;
import io.axual.client.proxy.generic.producer.ProducerProxy;
import io.axual.client.proxy.switching.generic.BaseClientProxySwitcher;
import io.axual.client.proxy.switching.producer.SwitchingProducerConfig;
import io.axual.discovery.client.DiscoveryResult;
import java.time.Duration;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerSwitcher<K, V>
extends BaseClientProxySwitcher<ProducerProxy<K, V>, SwitchingProducerConfig<K, V>> {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerSwitcher.class);

    @Override
    protected ProducerProxy<K, V> createProxyObject(SwitchingProducerConfig config, DiscoveryResult discoveryResult) {
        Map properties = config.getDownstreamConfigs();
        properties.putAll(discoveryResult.getConfigs());
        LOG.info("Creating a new {} with properties: {}", (Object)config.getProxyType(), (Object)properties);
        ClientProxyFactory factory = config.getBackingFactory();
        return (ProducerProxy)factory.create(properties);
    }

    @Override
    protected Duration getSwitchTimeout(SwitchingProducerConfig config, DiscoveryResult oldResult, DiscoveryResult newResult) {
        if (config.awaitDistributorOnSwitch()) {
            return super.getSwitchTimeout(config, oldResult, newResult);
        }
        return Duration.ZERO;
    }
}

