/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.axual.serde;

import io.axual.client.proxy.axual.serde.AxualSerializerConfig;
import io.axual.client.proxy.generic.registry.ProxyChainUtil;
import io.axual.client.proxy.generic.serde.BaseSerializerProxy;
import io.axual.client.proxy.generic.serde.SerializerProxyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;

public class AxualSerializer<T>
extends BaseSerializerProxy<T, AxualSerializerConfig<T>> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new AxualSerializerConfig(new HashMap<String, Object>(configs), isKey));
        HashMap<String, Object> serializerConfigs = new HashMap<String, Object>(configs);
        Object defaultSerializer = configs.get("axualserializer.default.serializer");
        serializerConfigs.put("wrappedserializer.serializer", defaultSerializer);
        SerializerProxyFactory factory = ProxyChainUtil.setupSerializerFactoryChain(((AxualSerializerConfig)this.config).getProxyChain());
        this.backingSerializer = factory.create(serializerConfigs, isKey);
    }

    public byte[] serialize(String topic, Headers headers, T data) {
        return this.backingSerializer.serialize(topic, headers, data);
    }
}

