/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.generic.registry;

import io.axual.client.proxy.callback.admin.CallbackAdminFactory;
import io.axual.client.proxy.callback.consumer.CallbackConsumerFactory;
import io.axual.client.proxy.callback.producer.CallbackProducerFactory;
import io.axual.client.proxy.callback.serde.CallbackDeserializerFactory;
import io.axual.client.proxy.callback.serde.CallbackSerializerFactory;
import io.axual.client.proxy.generic.proxy.ProxyFactory;
import io.axual.client.proxy.header.consumer.HeaderConsumerFactory;
import io.axual.client.proxy.header.producer.HeaderProducerFactory;
import io.axual.client.proxy.header.serde.HeaderDeserializerFactory;
import io.axual.client.proxy.header.serde.HeaderSerializerFactory;
import io.axual.client.proxy.lineage.consumer.LineageConsumerFactory;
import io.axual.client.proxy.lineage.producer.LineageProducerFactory;
import io.axual.client.proxy.lineage.serde.LineageDeserializerFactory;
import io.axual.client.proxy.lineage.serde.LineageSerializerFactory;
import io.axual.client.proxy.logging.admin.LoggingAdminFactory;
import io.axual.client.proxy.logging.consumer.LoggingConsumerFactory;
import io.axual.client.proxy.logging.producer.LoggingProducerFactory;
import io.axual.client.proxy.logging.serde.LoggingDeserializerFactory;
import io.axual.client.proxy.logging.serde.LoggingSerializerFactory;
import io.axual.client.proxy.noop.admin.NoOpAdminFactory;
import io.axual.client.proxy.noop.serde.NoOpDeserializerFactory;
import io.axual.client.proxy.noop.serde.NoOpSerializerFactory;
import io.axual.client.proxy.resolving.admin.ResolvingAdminFactory;
import io.axual.client.proxy.resolving.consumer.ResolvingConsumerFactory;
import io.axual.client.proxy.resolving.producer.ResolvingProducerFactory;
import io.axual.client.proxy.resolving.serde.ResolvingDeserializerFactory;
import io.axual.client.proxy.resolving.serde.ResolvingSerializerFactory;
import io.axual.client.proxy.switching.admin.SwitchingAdminFactory;
import io.axual.client.proxy.switching.consumer.SwitchingConsumerFactory;
import io.axual.client.proxy.switching.producer.SwitchingProducerFactory;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class ProxyTypeRegistry {
    private static final Map<ProxyType, Map<String, ProxyTypeRegistration>> proxyRegistration = new EnumMap<ProxyType, Map<String, ProxyTypeRegistration>>(ProxyType.class);
    public static final String CALLBACK_PROXY_ID = "CALLBACK";
    public static final String HEADER_PROXY_ID = "HEADER";
    public static final String LINEAGE_PROXY_ID = "LINEAGE";
    public static final String LOGGING_PROXY_ID = "LOGGING";
    public static final String RESOLVING_PROXY_ID = "RESOLVING";
    public static final String SWITCHING_PROXY_ID = "SWITCHING";

    private ProxyTypeRegistry() {
    }

    public static void registerProxyType(ProxyType type, String id, Class<? extends ProxyFactory> factoryClass, String backingFactoryPropertyName) {
        if (!proxyRegistration.containsKey((Object)type)) {
            proxyRegistration.put(type, new HashMap());
        }
        proxyRegistration.get((Object)type).put(id, new ProxyTypeRegistration(factoryClass.getName(), backingFactoryPropertyName));
    }

    static ProxyTypeRegistration getProxyRegistration(ProxyType type, String id) {
        if (proxyRegistration.containsKey((Object)type)) {
            return proxyRegistration.get((Object)type).get(id);
        }
        return null;
    }

    static {
        ProxyTypeRegistry.registerProxyType(ProxyType.ADMIN, CALLBACK_PROXY_ID, CallbackAdminFactory.class, "callbackadmin.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.CONSUMER, CALLBACK_PROXY_ID, CallbackConsumerFactory.class, "callbackconsumer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.PRODUCER, CALLBACK_PROXY_ID, CallbackProducerFactory.class, "callbackproducer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.DESERIALIZER, CALLBACK_PROXY_ID, CallbackDeserializerFactory.class, "callbackdeserializer.backing.deserializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.SERIALIZER, CALLBACK_PROXY_ID, CallbackSerializerFactory.class, "callbackserializer.backing.serializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.ADMIN, HEADER_PROXY_ID, NoOpAdminFactory.class, "noopadmin.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.CONSUMER, HEADER_PROXY_ID, HeaderConsumerFactory.class, "headerconsumer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.PRODUCER, HEADER_PROXY_ID, HeaderProducerFactory.class, "headerproducer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.DESERIALIZER, HEADER_PROXY_ID, HeaderDeserializerFactory.class, "headerdeserializer.backing.deserializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.SERIALIZER, HEADER_PROXY_ID, HeaderSerializerFactory.class, "headerserializer.backing.serializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.ADMIN, LINEAGE_PROXY_ID, NoOpAdminFactory.class, "noopadmin.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.CONSUMER, LINEAGE_PROXY_ID, LineageConsumerFactory.class, "lineageconsumer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.PRODUCER, LINEAGE_PROXY_ID, LineageProducerFactory.class, "lineageproducer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.DESERIALIZER, LINEAGE_PROXY_ID, LineageDeserializerFactory.class, "lineagedeserializer.backing.deserializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.SERIALIZER, LINEAGE_PROXY_ID, LineageSerializerFactory.class, "lineageserializer.backing.serializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.ADMIN, LOGGING_PROXY_ID, LoggingAdminFactory.class, "loggingadmin.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.CONSUMER, LOGGING_PROXY_ID, LoggingConsumerFactory.class, "loggingconsumer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.PRODUCER, LOGGING_PROXY_ID, LoggingProducerFactory.class, "loggingproducer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.DESERIALIZER, LOGGING_PROXY_ID, LoggingDeserializerFactory.class, "loggingdeserializer.backing.deserializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.SERIALIZER, LOGGING_PROXY_ID, LoggingSerializerFactory.class, "loggingserializer.backing.serializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.ADMIN, RESOLVING_PROXY_ID, ResolvingAdminFactory.class, "resolvingadmin.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.CONSUMER, RESOLVING_PROXY_ID, ResolvingConsumerFactory.class, "resolvingconsumer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.PRODUCER, RESOLVING_PROXY_ID, ResolvingProducerFactory.class, "resolvingproducer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.DESERIALIZER, RESOLVING_PROXY_ID, ResolvingDeserializerFactory.class, "resolvingdeserializer.backing.deserializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.SERIALIZER, RESOLVING_PROXY_ID, ResolvingSerializerFactory.class, "resolving.backing.serializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.ADMIN, SWITCHING_PROXY_ID, SwitchingAdminFactory.class, "switchingadmin.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.CONSUMER, SWITCHING_PROXY_ID, SwitchingConsumerFactory.class, "switchingconsumer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.PRODUCER, SWITCHING_PROXY_ID, SwitchingProducerFactory.class, "switchingproducer.backing.factory");
        ProxyTypeRegistry.registerProxyType(ProxyType.DESERIALIZER, SWITCHING_PROXY_ID, NoOpDeserializerFactory.class, "noopdeserializer.backing.deserializer");
        ProxyTypeRegistry.registerProxyType(ProxyType.SERIALIZER, SWITCHING_PROXY_ID, NoOpSerializerFactory.class, "noopserializer.backing.serializer");
    }

    public static class ProxyTypeRegistration {
        private final String backingClassName;
        private final String backingPropertyName;

        private ProxyTypeRegistration(String backingClassName, String backingPropertyName) {
            this.backingPropertyName = backingPropertyName;
            this.backingClassName = backingClassName;
        }

        String getBackingClassName() {
            return this.backingClassName;
        }

        String getBackingPropertyName() {
            return this.backingPropertyName;
        }
    }

    public static enum ProxyType {
        ADMIN,
        CONSUMER,
        PRODUCER,
        DESERIALIZER,
        SERIALIZER;

    }
}

