/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.header.serde;

import io.axual.client.proxy.generic.serde.BaseDeserializerProxy;
import io.axual.client.proxy.header.serde.HeaderDeserializerConfig;
import io.axual.serde.utils.HeaderUtils;
import io.axual.serde.utils.SerdeUtils;
import io.axual.serde.valueheader.ValueHeader;
import io.axual.serde.valueheader.ValueHeaderDeserializer;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.header.Headers;

public class HeaderDeserializer<T>
extends BaseDeserializerProxy<T, HeaderDeserializerConfig<T>> {
    private ValueHeaderDeserializer valueHeaderDeserializer;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new HeaderDeserializerConfig(new HashMap<String, Object>(configs), isKey));
        this.valueHeaderDeserializer = new ValueHeaderDeserializer();
        this.valueHeaderDeserializer.configure(((HeaderDeserializerConfig)this.config).getDownstreamConfigs(), isKey);
    }

    @Override
    public T deserialize(String topic, byte[] data) {
        return this.deserialize(topic, null, data);
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        if (!((HeaderDeserializerConfig)this.config).isKey() && SerdeUtils.containsValueHeader((byte[])data)) {
            byte[] body;
            int headerSize = SerdeUtils.getValueHeaderSize((byte[])data);
            byte[] byArray = body = data.length > headerSize ? Arrays.copyOfRange(data, headerSize, data.length) : null;
            if (headers != null) {
                HeaderDeserializer.copyValueHeaderToKafkaHeaders(this.valueHeaderDeserializer.deserialize(topic, headers, data), headers);
            }
            return (T)this.backingDeserializer.deserialize(topic, headers, body);
        }
        return (T)this.backingDeserializer.deserialize(topic, headers, data);
    }

    private static void copyValueHeaderToKafkaHeaders(ValueHeader valueHeader, Headers kafkaHeaders) {
        if (kafkaHeaders.lastHeader("Axual-Message-Id") == null) {
            HeaderUtils.addUuidHeader((Headers)kafkaHeaders, (String)"Axual-Message-Id", (UUID)valueHeader.getMessageId());
        }
        if (kafkaHeaders.lastHeader("Axual-Serialization-Time") == null) {
            HeaderUtils.addLongHeader((Headers)kafkaHeaders, (String)"Axual-Serialization-Time", (Long)valueHeader.getSerializationTimestamp());
        }
        if (kafkaHeaders.lastHeader("Axual-Copy-Flags") == null) {
            HeaderUtils.addIntegerHeader((Headers)kafkaHeaders, (String)"Axual-Copy-Flags", (Integer)(valueHeader.getCopyFlags() & 0xFF));
        }
    }

    @Override
    public void close(Duration duration) {
        this.valueHeaderDeserializer.close();
        super.close(duration);
    }
}

