/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.lineage.core;

import io.axual.client.proxy.lineage.core.LineageConfig;
import io.axual.serde.utils.HeaderUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class LineageAppender {
    private static final Set<String> LINEAGE_HEADERS = new HashSet<String>();

    private LineageAppender() {
    }

    public static Headers clearLineageHeaders(Headers headers) {
        RecordHeaders result = new RecordHeaders();
        for (Header header : headers) {
            if (LINEAGE_HEADERS.contains(header.key())) continue;
            result.add(header.key(), header.value());
        }
        return result;
    }

    public static void appendLineageForDeserialization(Headers headers, LineageConfig config) {
        if (headers != null) {
            LineageAppender.append(headers, "Axual-Deserialization-Time", System.currentTimeMillis(), true);
            LineageAppender.append(headers, "Axual-Tenant", config.getTenant(), false);
            LineageAppender.append(headers, "Axual-Environment", config.getEnvironment(), false);
            LineageAppender.append(headers, "Axual-Intermediate-Id", config.getApplicationId(), true);
            LineageAppender.append(headers, "Axual-Intermediate-Version", config.getApplicationVersion(), true);
            LineageAppender.append(headers, "Axual-System", config.getSystem(), false);
            LineageAppender.append(headers, "Axual-Instance", config.getInstance(), false);
            LineageAppender.append(headers, "Axual-Cluster", config.getCluster(), false);
        }
    }

    public static void appendLineageForSerialization(Headers headers, LineageConfig config) {
        if (headers != null) {
            headers.remove("Axual-Deserialization-Time");
            if (!config.isSystemProduceEnabled()) {
                headers.remove("Axual-Copy-Flags");
                headers.remove("Axual-Message-Id");
            }
            if (headers.lastHeader("Axual-Message-Id") == null) {
                HeaderUtils.addUuidHeader((Headers)headers, (String)"Axual-Message-Id", (UUID)UUID.randomUUID());
            }
            if (headers.lastHeader("Axual-Producer-Id") == null && config.getApplicationId() != null) {
                headers.remove("Axual-Producer-Version");
                HeaderUtils.addStringHeader((Headers)headers, (String)"Axual-Producer-Id", (String)config.getApplicationId());
                HeaderUtils.addStringHeader((Headers)headers, (String)"Axual-Producer-Version", (String)config.getApplicationVersion());
            }
            headers.remove("Axual-Intermediate-Id");
            headers.remove("Axual-Intermediate-Version");
            HeaderUtils.addStringHeader((Headers)headers, (String)"Axual-Intermediate-Id", (String)config.getApplicationId());
            HeaderUtils.addStringHeader((Headers)headers, (String)"Axual-Intermediate-Version", (String)config.getApplicationVersion());
            headers.remove("Axual-Serialization-Time");
            HeaderUtils.addLongHeader((Headers)headers, (String)"Axual-Serialization-Time", (Long)System.currentTimeMillis());
            LineageAppender.append(headers, "Axual-Tenant", config.getTenant(), true);
            LineageAppender.append(headers, "Axual-Environment", config.getEnvironment(), true);
            LineageAppender.append(headers, "Axual-Intermediate-Id", config.getApplicationId(), true);
            LineageAppender.append(headers, "Axual-Intermediate-Version", config.getApplicationVersion(), true);
            LineageAppender.append(headers, "Axual-System", config.getSystem(), true);
            LineageAppender.append(headers, "Axual-Instance", config.getInstance(), true);
            LineageAppender.append(headers, "Axual-Cluster", config.getCluster(), true);
        }
    }

    private static void append(Headers headers, String headerKey, String headerValue, boolean overwrite) {
        if (headers != null) {
            if (overwrite) {
                headers.remove(headerKey);
            }
            if (headers.lastHeader(headerKey) == null) {
                HeaderUtils.addStringHeader((Headers)headers, (String)headerKey, (String)headerValue);
            }
        }
    }

    private static void append(Headers headers, String headerKey, Long headerValue, boolean overwrite) {
        if (headers != null) {
            if (overwrite) {
                headers.remove(headerKey);
            }
            if (headers.lastHeader(headerKey) == null) {
                HeaderUtils.addLongHeader((Headers)headers, (String)headerKey, (Long)headerValue);
            }
        }
    }

    static {
        LINEAGE_HEADERS.add("Axual-Message-Id");
        LINEAGE_HEADERS.add("Axual-Serialization-Time");
        LINEAGE_HEADERS.add("Axual-Deserialization-Time");
        LINEAGE_HEADERS.add("Axual-Copy-Flags");
        LINEAGE_HEADERS.add("Axual-Producer-Id");
        LINEAGE_HEADERS.add("Axual-Producer-Version");
        LINEAGE_HEADERS.add("Axual-Intermediate-Id");
        LINEAGE_HEADERS.add("Axual-Intermediate-Version");
        LINEAGE_HEADERS.add("Axual-System");
        LINEAGE_HEADERS.add("Axual-Instance");
        LINEAGE_HEADERS.add("Axual-Cluster");
        LINEAGE_HEADERS.add("Axual-Tenant");
        LINEAGE_HEADERS.add("Axual-Environment");
    }
}

