/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.logging.core;

import io.axual.client.proxy.logging.core.LogLevel;
import io.axual.common.config.ConfigParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LoggingConfig {
    public static final String LOGLEVEL_CONFIG = "level";
    public static final String METHODS_CONFIG = "methods";
    public static final String NAME_CONFIG = "name";
    private final LogLevel level;
    private final Set<String> methods;
    private final String name;

    private LoggingConfig(LogLevel level, Set<String> methods, String name) {
        this.level = level;
        this.methods = methods;
        this.name = name;
    }

    public static LoggingConfig parse(Map<String, Object> configs) {
        LogLevel level = LogLevel.parse(ConfigParser.parseAndRemoveConfig(configs, (String)LOGLEVEL_CONFIG, (boolean)false, (Object)((Object)LogLevel.DEBUG)));
        HashSet<String> methods = new HashSet<String>(Arrays.asList(ConfigParser.parseAndRemoveStringConfig(configs, (String)METHODS_CONFIG, (boolean)false, (String)"").split(",")));
        methods.remove("");
        String name = ConfigParser.parseAndRemoveStringConfig(configs, (String)NAME_CONFIG, (boolean)false, (String)"");
        return new LoggingConfig(level, methods, name);
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public Set<String> getMethods() {
        return this.methods;
    }

    public String getName() {
        return this.name;
    }
}

