/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.admin;

import io.axual.common.resolver.GroupResolver;
import io.axual.common.resolver.TopicResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;

public class ResolverUtil {
    private ResolverUtil() {
    }

    public static AclBindingFilter resolve(AclBindingFilter filter, TopicResolver topicResolver, GroupResolver groupResolver) {
        String name = filter.patternFilter().name();
        switch (filter.patternFilter().resourceType()) {
            case TOPIC: {
                name = topicResolver.resolveTopic(name);
                break;
            }
            case GROUP: {
                name = groupResolver.resolveGroup(name);
                break;
            }
        }
        return new AclBindingFilter(new ResourcePatternFilter(filter.patternFilter().resourceType(), name, filter.patternFilter().patternType()), filter.entryFilter());
    }

    public static Collection<AclBinding> unresolve(Collection<AclBinding> bindings, TopicResolver topicResolver, GroupResolver groupResolver) {
        ArrayList<AclBinding> result = new ArrayList<AclBinding>(bindings.size());
        for (AclBinding binding : bindings) {
            String name = binding.pattern().name();
            switch (binding.pattern().resourceType()) {
                case TOPIC: {
                    name = topicResolver.unresolveTopic(name);
                    break;
                }
                case GROUP: {
                    name = groupResolver.unresolveGroup(name);
                    break;
                }
            }
            result.add(new AclBinding(new ResourcePattern(binding.pattern().resourceType(), name, binding.pattern().patternType()), binding.entry()));
        }
        return result;
    }

    public static <T> Map<String, T> unresolve(Map<String, T> map, TopicResolver resolver) {
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String unresolved = resolver.unresolveTopic(entry.getKey());
            if (unresolved == null) continue;
            result.put(unresolved, entry.getValue());
        }
        return result;
    }
}

