/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.consumer;

import io.axual.client.proxy.resolving.consumer.ResolvingConsumerPartitionAssignorConfig;
import io.axual.common.resolver.TopicResolver;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.PartitionInfo;

public class ResolvingConsumerPartitionAssignor
implements ConsumerPartitionAssignor,
Configurable {
    private ConsumerPartitionAssignor proxiedObject = null;
    private TopicResolver resolver = null;

    public void configure(Map<String, ?> configs) {
        ResolvingConsumerPartitionAssignorConfig config = new ResolvingConsumerPartitionAssignorConfig(new HashMap<String, Object>(configs));
        this.proxiedObject = config.getBackingAssignor();
        this.resolver = config.getTopicResolver();
    }

    public ByteBuffer subscriptionUserData(Set<String> topics) {
        return this.proxiedObject.subscriptionUserData(topics);
    }

    public ConsumerPartitionAssignor.GroupAssignment assign(Cluster cluster, ConsumerPartitionAssignor.GroupSubscription subscriptions) {
        Cluster unresolvedCluster = new Cluster(cluster.clusterResource().clusterId(), (Collection)cluster.nodes(), this.unresolveClusterPartitions(cluster), this.resolver.unresolveTopics((Collection)cluster.unauthorizedTopics()), cluster.internalTopics(), cluster.controller());
        HashMap unresolvedSubscriptions = new HashMap();
        for (Map.Entry subscription : subscriptions.groupSubscription().entrySet()) {
            unresolvedSubscriptions.put(subscription.getKey(), this.unresolveSubscription((ConsumerPartitionAssignor.Subscription)subscription.getValue()));
        }
        ConsumerPartitionAssignor.GroupSubscription unresolvedGroupSubscriptions = new ConsumerPartitionAssignor.GroupSubscription(unresolvedSubscriptions);
        ConsumerPartitionAssignor.GroupAssignment assignments = this.proxiedObject.assign(unresolvedCluster, unresolvedGroupSubscriptions);
        HashMap result = new HashMap();
        for (Map.Entry assignmentEntry : assignments.groupAssignment().entrySet()) {
            result.put(assignmentEntry.getKey(), this.resolveAssignment((ConsumerPartitionAssignor.Assignment)assignmentEntry.getValue()));
        }
        return new ConsumerPartitionAssignor.GroupAssignment(result);
    }

    public void onAssignment(ConsumerPartitionAssignor.Assignment assignment, ConsumerGroupMetadata metadata) {
        this.proxiedObject.onAssignment(this.unresolveAssignment(assignment), metadata);
    }

    public List<ConsumerPartitionAssignor.RebalanceProtocol> supportedProtocols() {
        return this.proxiedObject.supportedProtocols();
    }

    public short version() {
        return 1;
    }

    public String name() {
        return this.proxiedObject.name();
    }

    private List<PartitionInfo> unresolveClusterPartitions(Cluster proxiedCluster) {
        ArrayList<PartitionInfo> result = new ArrayList<PartitionInfo>();
        for (String topic : proxiedCluster.topics()) {
            List partitions = proxiedCluster.availablePartitionsForTopic(topic);
            for (PartitionInfo partition : partitions) {
                result.add(new PartitionInfo(this.resolver.unresolveTopic(partition.topic()), partition.partition(), partition.leader(), partition.replicas(), partition.inSyncReplicas(), partition.offlineReplicas()));
            }
        }
        return result;
    }

    private ConsumerPartitionAssignor.Assignment resolveAssignment(ConsumerPartitionAssignor.Assignment assignment) {
        return new ConsumerPartitionAssignor.Assignment(new ArrayList(this.resolver.resolveTopicPartitions((Collection)assignment.partitions())), assignment.userData());
    }

    private ConsumerPartitionAssignor.Assignment unresolveAssignment(ConsumerPartitionAssignor.Assignment assignment) {
        return new ConsumerPartitionAssignor.Assignment(new ArrayList(this.resolver.unresolveTopicPartitions((Collection)assignment.partitions())), assignment.userData());
    }

    private ConsumerPartitionAssignor.Subscription unresolveSubscription(ConsumerPartitionAssignor.Subscription subscription) {
        return new ConsumerPartitionAssignor.Subscription(new ArrayList(this.resolver.unresolveTopics((Collection)subscription.topics())), subscription.userData(), new ArrayList(this.resolver.unresolveTopicPartitions((Collection)subscription.ownedPartitions())));
    }
}

