/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.wrapped.serde;

import io.axual.common.exception.ClientException;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;

public class WrappedDeserializerInstance<T>
implements Deserializer<T> {
    public static final String KEY_DESERIALIZER_INSTANCE_CONFIG = "wrappeddeserializerinstance.key.deserializer";
    public static final String VALUE_DESERIALIZER_INSTANCE_CONFIG = "wrappeddeserializerinstance.value.deserializer";
    private Deserializer<T> deserializerInstance;

    public void configure(Map<String, ?> configs, boolean isKey) {
        Object deserializer = configs.get(isKey ? KEY_DESERIALIZER_INSTANCE_CONFIG : VALUE_DESERIALIZER_INSTANCE_CONFIG);
        if (!(deserializer instanceof Deserializer)) {
            throw new ClientException("Illegal deserializer passed as instance argument");
        }
        this.deserializerInstance = (Deserializer)deserializer;
        this.deserializerInstance.configure(configs, isKey);
    }

    public T deserialize(String topic, byte[] data) {
        return (T)this.deserializerInstance.deserialize(topic, data);
    }

    public void close() {
        if (this.deserializerInstance != null) {
            this.deserializerInstance.close();
            this.deserializerInstance = null;
        }
    }
}

