/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.wrapped.serde;

import io.axual.common.exception.ClientException;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;

public class WrappedSerializerInstance<T>
implements Serializer<T> {
    public static final String KEY_SERIALIZER_INSTANCE_CONFIG = "wrappedserializerinstance.key.serializer";
    public static final String VALUE_SERIALIZER_INSTANCE_CONFIG = "wrappedserializerinstance.value.serializer";
    private Serializer<T> serializerInstance;

    public void configure(Map<String, ?> configs, boolean isKey) {
        Object serializer = configs.get(isKey ? KEY_SERIALIZER_INSTANCE_CONFIG : VALUE_SERIALIZER_INSTANCE_CONFIG);
        if (!(serializer instanceof Serializer)) {
            throw new ClientException("Illegal serializer passed as instance argument");
        }
        this.serializerInstance = (Serializer)serializer;
        this.serializerInstance.configure(configs, isKey);
    }

    public byte[] serialize(String topic, T object) {
        return this.serializerInstance.serialize(topic, object);
    }

    public void close() {
        if (this.serializerInstance != null) {
            this.serializerInstance.close();
            this.serializerInstance = null;
        }
    }
}

