/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.callback.consumer;

import io.axual.client.proxy.callback.client.CallbackClientProxy;
import io.axual.client.proxy.callback.consumer.CallbackConsumerConfig;
import io.axual.client.proxy.generic.consumer.ConsumerProxy;
import io.axual.client.proxy.generic.tools.SerdeUtil;
import io.axual.common.tools.MapUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Serializer;

public class CallbackConsumer<K, V>
extends CallbackClientProxy<ConsumerProxy<K, V>, CallbackConsumerConfig<K, V>>
implements ConsumerProxy<K, V> {
    private static final String SUBSCRIBE = "subscribe";
    private static final String TOPICS = "topics";
    private static final String TIMEOUT = "timeout";
    private static final String COMMIT_SYNC = "commitSync";
    private static final String OFFSETS = "offsets";
    private static final String COMMIT_ASYNC = "commitAsync";
    private static final String PARTITION = "partition";
    private static final String PARTITIONS = "partitions";
    private static final String COMMITTED = "committed";

    public CallbackConsumer(Map<String, Object> configs) {
        super(new CallbackConsumerConfig(configs));
    }

    public CallbackConsumer(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(SerdeUtil.addSerializersToConfigs(configs, keySerializer, valueSerializer));
    }

    public CallbackConsumer(Properties properties) {
        this(MapUtil.objectToStringMap((Map)properties));
    }

    public CallbackConsumer(Properties properties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(MapUtil.objectToStringMap((Map)properties), keySerializer, valueSerializer);
    }

    public Set<TopicPartition> assignment() {
        return this.interceptor.exec(this, "assignment", () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).assignment());
    }

    public Set<String> subscription() {
        return this.interceptor.exec(this, "subscription", () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).subscription());
    }

    public void subscribe(Collection<String> topics) {
        this.interceptor.execProc(this, SUBSCRIBE, () -> ((ConsumerProxy)this.proxiedObject).subscribe(topics), new String[]{TOPICS}, topics);
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        this.interceptor.execProc(this, SUBSCRIBE, () -> ((ConsumerProxy)this.proxiedObject).subscribe(topics, listener), new String[]{TOPICS, "listener"}, topics, listener);
    }

    public void assign(Collection<TopicPartition> topicPartitions) {
        this.interceptor.execProc(this, "assign", () -> ((ConsumerProxy)this.proxiedObject).assign(topicPartitions), new String[]{"topicPartitions"}, topicPartitions);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        this.interceptor.execProc(this, SUBSCRIBE, () -> ((ConsumerProxy)this.proxiedObject).subscribe(pattern, listener), new String[]{"pattern", "listener"}, pattern, listener);
    }

    public void subscribe(Pattern pattern) {
        this.interceptor.execProc(this, SUBSCRIBE, () -> ((ConsumerProxy)this.proxiedObject).subscribe(pattern), new String[]{"pattern"}, pattern);
    }

    public void unsubscribe() {
        this.interceptor.execProc(this, "unsubscribe", () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).unsubscribe());
    }

    @Deprecated
    public ConsumerRecords<K, V> poll(long timeout) {
        return this.interceptor.exec(this, "poll", () -> ((ConsumerProxy)this.proxiedObject).poll(timeout), new String[]{TIMEOUT}, timeout);
    }

    public ConsumerRecords<K, V> poll(Duration timeout) {
        return this.interceptor.exec(this, "poll", () -> ((ConsumerProxy)this.proxiedObject).poll(timeout), new String[]{TIMEOUT}, timeout);
    }

    public void commitSync() {
        this.interceptor.execProc(this, COMMIT_SYNC, () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).commitSync());
    }

    public void commitSync(Duration timeout) {
        this.interceptor.execProc(this, COMMIT_SYNC, () -> ((ConsumerProxy)this.proxiedObject).commitSync(timeout), new String[]{TIMEOUT}, timeout);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.interceptor.execProc(this, COMMIT_SYNC, () -> ((ConsumerProxy)this.proxiedObject).commitSync(offsets), new String[]{OFFSETS}, offsets);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.interceptor.execProc(this, COMMIT_SYNC, () -> ((ConsumerProxy)this.proxiedObject).commitSync(offsets, timeout), new String[]{OFFSETS, TIMEOUT}, offsets, timeout);
    }

    public void commitAsync() {
        this.interceptor.execProc(this, COMMIT_ASYNC, () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).commitAsync());
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this.interceptor.execProc(this, COMMIT_ASYNC, () -> ((ConsumerProxy)this.proxiedObject).commitAsync(callback), new String[]{"callback"}, callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.interceptor.execProc(this, COMMIT_ASYNC, () -> ((ConsumerProxy)this.proxiedObject).commitAsync(offsets, callback), new String[]{OFFSETS, "callback"}, offsets, callback);
    }

    public void seek(TopicPartition partition, long offset) {
        this.interceptor.execProc(this, "seek", () -> ((ConsumerProxy)this.proxiedObject).seek(partition, offset), new String[]{PARTITION, "offset"}, partition, offset);
    }

    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        this.interceptor.execProc(this, "seek", () -> ((ConsumerProxy)this.proxiedObject).seek(partition, offsetAndMetadata), new String[]{PARTITION, "offsetAndMetadata"}, partition, offsetAndMetadata);
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.interceptor.execProc(this, "seekToBeginning", () -> ((ConsumerProxy)this.proxiedObject).seekToBeginning(partitions), new String[]{PARTITIONS}, partitions);
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.interceptor.execProc(this, "seekToEnd", () -> ((ConsumerProxy)this.proxiedObject).seekToEnd(partitions), new String[]{PARTITION}, partitions);
    }

    public long position(TopicPartition partition) {
        return this.interceptor.exec(this, "position", () -> ((ConsumerProxy)this.proxiedObject).position(partition), new String[]{PARTITION}, partition);
    }

    public long position(TopicPartition partition, Duration timeout) {
        return this.interceptor.exec(this, "position", () -> ((ConsumerProxy)this.proxiedObject).position(partition, timeout), new String[]{PARTITION, TIMEOUT}, partition, timeout);
    }

    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.interceptor.exec(this, COMMITTED, () -> ((ConsumerProxy)this.proxiedObject).committed(partition), new String[]{PARTITION}, partition);
    }

    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        return this.interceptor.exec(this, COMMITTED, () -> ((ConsumerProxy)this.proxiedObject).committed(partition, timeout), new String[]{PARTITION, TIMEOUT}, partition, timeout);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return this.interceptor.exec(this, COMMITTED, () -> ((ConsumerProxy)this.proxiedObject).committed(partitions), new String[]{PARTITIONS, TIMEOUT}, partitions);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        return this.interceptor.exec(this, COMMITTED, () -> ((ConsumerProxy)this.proxiedObject).committed(partitions, timeout), new String[]{PARTITIONS, TIMEOUT}, partitions, timeout);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.interceptor.exec(this, "metrics", () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).metrics());
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.interceptor.exec(this, "partitionsFor", () -> ((ConsumerProxy)this.proxiedObject).partitionsFor(topic), new String[]{"topic"}, topic);
    }

    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        return this.interceptor.exec(this, "partitionsFor", () -> ((ConsumerProxy)this.proxiedObject).partitionsFor(topic, timeout), new String[]{"topic", TIMEOUT}, topic, timeout);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.interceptor.exec(this, "listTopics", () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).listTopics());
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        return this.interceptor.exec(this, "listTopics", () -> ((ConsumerProxy)this.proxiedObject).listTopics(timeout), new String[]{TIMEOUT}, timeout);
    }

    public Set<TopicPartition> paused() {
        return this.interceptor.exec(this, "paused", () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).paused());
    }

    public void pause(Collection<TopicPartition> topics) {
        this.interceptor.execProc(this, "pause", () -> ((ConsumerProxy)this.proxiedObject).pause(topics), new String[]{TOPICS}, topics);
    }

    public void resume(Collection<TopicPartition> topics) {
        this.interceptor.execProc(this, "resume", () -> ((ConsumerProxy)this.proxiedObject).resume(topics), new String[]{TOPICS}, topics);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestamps) {
        return this.interceptor.exec(this, "offsetsForTimes", () -> ((ConsumerProxy)this.proxiedObject).offsetsForTimes(timestamps), new String[]{"timestamps"}, timestamps);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestamps, Duration timeout) {
        return this.interceptor.exec(this, "offsetsForTimes", () -> ((ConsumerProxy)this.proxiedObject).offsetsForTimes(timestamps, timeout), new String[]{"timestamps", TIMEOUT}, timestamps, timeout);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.interceptor.exec(this, "beginningOffsets", () -> ((ConsumerProxy)this.proxiedObject).beginningOffsets(partitions), new String[]{PARTITIONS}, partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.interceptor.exec(this, "beginningOffsets", () -> ((ConsumerProxy)this.proxiedObject).beginningOffsets(partitions, timeout), new String[]{PARTITIONS, TIMEOUT}, partitions, timeout);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.interceptor.exec(this, "endOffsets", () -> ((ConsumerProxy)this.proxiedObject).endOffsets(partitions), new String[]{PARTITIONS}, partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.interceptor.exec(this, "endOffsets", () -> ((ConsumerProxy)this.proxiedObject).endOffsets(partitions, timeout), new String[]{PARTITIONS, TIMEOUT}, partitions, timeout);
    }

    public ConsumerGroupMetadata groupMetadata() {
        return this.interceptor.exec(this, "groupMetadata", () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).groupMetadata());
    }

    public void enforceRebalance() {
        this.interceptor.execProc(this, "enforceRebalance", () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).enforceRebalance());
    }

    @Override
    public void close(Duration timeout) {
        this.interceptor.execProc(this, "close", () -> super.close(timeout), new String[]{TIMEOUT}, timeout);
    }

    public void wakeup() {
        this.interceptor.execProc(this, "wakeup", () -> ((ConsumerProxy)((ConsumerProxy)this.proxiedObject)).wakeup());
    }
}

