/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.generic.tools;

import io.axual.client.proxy.wrapped.serde.WrappedDeserializerInstance;
import io.axual.client.proxy.wrapped.serde.WrappedSerializerInstance;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

public class SerdeUtil {
    private SerdeUtil() {
    }

    public static Map<String, Object> addDeserializersToConfigs(Map<String, Object> configs, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
        if (keyDeserializer != null) {
            newConfigs.put("key.deserializer", WrappedDeserializerInstance.class);
            newConfigs.put("wrappeddeserializerinstance.key.deserializer", keyDeserializer);
        }
        if (valueDeserializer != null) {
            newConfigs.put("value.deserializer", WrappedDeserializerInstance.class);
            newConfigs.put("wrappeddeserializerinstance.value.deserializer", valueDeserializer);
        }
        return newConfigs;
    }

    public static Map<String, Object> addSerializersToConfigs(Map<String, Object> configs, Serializer<?> keySerializer, Serializer<?> valueSerializer) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
        if (keySerializer != null) {
            newConfigs.put("key.serializer", WrappedSerializerInstance.class);
            newConfigs.put("wrappedserializerinstance.key.serializer", keySerializer);
        }
        if (valueSerializer != null) {
            newConfigs.put("value.serializer", WrappedSerializerInstance.class);
            newConfigs.put("wrappedserializerinstance.value.serializer", valueSerializer);
        }
        return newConfigs;
    }
}

