/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.admin;

import io.axual.client.proxy.generic.admin.AdminProxy;
import io.axual.client.proxy.generic.admin.StaticAdminProxy;
import io.axual.client.proxy.resolving.admin.ResolverUtil;
import io.axual.client.proxy.resolving.admin.ResolvingAdminConfig;
import io.axual.client.proxy.resolving.admin.ResolvingAlterConsumerGroupOffsetsResult;
import io.axual.client.proxy.resolving.admin.ResolvingCreateTopicsResult;
import io.axual.client.proxy.resolving.admin.ResolvingDeleteConsumerGroupOffsetsResult;
import io.axual.client.proxy.resolving.admin.ResolvingDeleteConsumerGroupsResult;
import io.axual.client.proxy.resolving.admin.ResolvingDeleteTopicsResult;
import io.axual.client.proxy.resolving.admin.ResolvingDescribeAclsResult;
import io.axual.client.proxy.resolving.admin.ResolvingDescribeConsumerGroupsResult;
import io.axual.client.proxy.resolving.admin.ResolvingDescribeTopicsResult;
import io.axual.client.proxy.resolving.admin.ResolvingListConsumerGroupOffsetsResult;
import io.axual.client.proxy.resolving.admin.ResolvingListConsumerGroupsResult;
import io.axual.client.proxy.resolving.admin.ResolvingListOffsetsResult;
import io.axual.client.proxy.resolving.admin.ResolvingListTopicsResult;
import io.axual.common.resolver.GroupResolver;
import io.axual.common.resolver.TopicResolver;
import io.axual.common.tools.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.ElectPreferredLeadersOptions;
import org.apache.kafka.clients.admin.ElectPreferredLeadersResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaFilter;

public class ResolvingAdminClient
extends StaticAdminProxy<ResolvingAdminConfig>
implements AdminProxy {
    public ResolvingAdminClient(Map<String, Object> configs) {
        super(new ResolvingAdminConfig(configs));
    }

    public static ResolvingAdminClient create(Properties properties) {
        return new ResolvingAdminClient(MapUtil.objectToStringMap((Map)properties));
    }

    public static ResolvingAdminClient create(Map<String, Object> configs) {
        return new ResolvingAdminClient(configs);
    }

    @Override
    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
        CreateTopicsResult result = super.createTopics(this.resolveNewTopics(newTopics), options);
        return new ResolvingCreateTopicsResult(result, ((ResolvingAdminConfig)this.config).getTopicResolver());
    }

    @Override
    public DeleteTopicsResult deleteTopics(Collection<String> topics, DeleteTopicsOptions options) {
        DeleteTopicsResult result = super.deleteTopics(((ResolvingAdminConfig)this.config).getTopicResolver().resolveTopics(topics), options);
        return new ResolvingDeleteTopicsResult(result != null ? result.values() : new HashMap(), ((ResolvingAdminConfig)this.config).getTopicResolver());
    }

    @Override
    public ListTopicsResult listTopics(ListTopicsOptions options) {
        return new ResolvingListTopicsResult(((AdminProxy)this.proxiedObject).listTopics(options), ((ResolvingAdminConfig)this.config).getTopicResolver());
    }

    @Override
    public DescribeTopicsResult describeTopics(Collection<String> topicNames, DescribeTopicsOptions options) {
        DescribeTopicsResult result = super.describeTopics(((ResolvingAdminConfig)this.config).getTopicResolver().resolveTopics(topicNames), options);
        return new ResolvingDescribeTopicsResult(result != null ? result.values() : new HashMap(), ((ResolvingAdminConfig)this.config).getTopicResolver());
    }

    @Override
    public DescribeAclsResult describeAcls(AclBindingFilter filter, DescribeAclsOptions options) {
        DescribeAclsResult result = super.describeAcls(ResolverUtil.resolve(filter, ((ResolvingAdminConfig)this.config).getTopicResolver(), ((ResolvingAdminConfig)this.config).getGroupResolver()), options);
        return result != null ? new ResolvingDescribeAclsResult((KafkaFuture<Collection<AclBinding>>)result.values(), ((ResolvingAdminConfig)this.config).getTopicResolver(), ((ResolvingAdminConfig)this.config).getGroupResolver()) : null;
    }

    @Override
    public CreateAclsResult createAcls(Collection<AclBinding> acls, CreateAclsOptions options) {
        this.operationNotSupported("createAcls");
        return null;
    }

    @Override
    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options) {
        this.operationNotSupported("deleteAcls");
        return null;
    }

    @Override
    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
        this.operationNotSupported("describeConfigs");
        return null;
    }

    @Override
    public synchronized AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
        this.operationNotSupported("alterConfigs");
        return null;
    }

    @Override
    public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
        this.operationNotSupported("incrementalAlterConfigs");
        return null;
    }

    @Override
    @Deprecated
    public ElectPreferredLeadersResult electPreferredLeaders(Collection<TopicPartition> partitions, ElectPreferredLeadersOptions options) {
        this.operationNotSupported("electPreferredLeaders");
        return null;
    }

    @Override
    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment, AlterReplicaLogDirsOptions options) {
        this.operationNotSupported("alterReplicaLogDirs");
        return null;
    }

    @Override
    public DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers, DescribeLogDirsOptions options) {
        this.operationNotSupported("describeLogDirs");
        return null;
    }

    @Override
    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas, DescribeReplicaLogDirsOptions options) {
        this.operationNotSupported("describeReplicaLogDirs");
        return null;
    }

    @Override
    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions, CreatePartitionsOptions options) {
        this.operationNotSupported("createPartitions");
        return null;
    }

    @Override
    public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete, DeleteRecordsOptions options) {
        return super.deleteRecords(((ResolvingAdminConfig)this.config).getTopicResolver().resolveTopics(recordsToDelete), options);
    }

    private Collection<NewTopic> resolveNewTopics(Collection<NewTopic> newTopics) {
        ArrayList<NewTopic> resolvedTopics = new ArrayList<NewTopic>();
        for (NewTopic newTopic : newTopics) {
            NewTopic resolvedNewTopic = newTopic.replicasAssignments() == null ? new NewTopic(((ResolvingAdminConfig)this.config).getTopicResolver().resolveTopic(newTopic.name()), newTopic.numPartitions(), newTopic.replicationFactor()) : new NewTopic(((ResolvingAdminConfig)this.config).getTopicResolver().resolveTopic(newTopic.name()), newTopic.replicasAssignments());
            resolvedTopics.add(resolvedNewTopic);
        }
        return resolvedTopics;
    }

    @Override
    public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds, DescribeConsumerGroupsOptions options) {
        GroupResolver groupResolver = ((ResolvingAdminConfig)this.config).getGroupResolver();
        return new ResolvingDescribeConsumerGroupsResult(super.describeConsumerGroups(groupResolver.resolveGroups(groupIds), options).describedGroups(), groupResolver);
    }

    @Override
    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String groupId, ListConsumerGroupOffsetsOptions options) {
        ListConsumerGroupOffsetsOptions resolvedOptions = new ListConsumerGroupOffsetsOptions();
        if (options != null && options.topicPartitions() != null) {
            TopicResolver resolver = ((ResolvingAdminConfig)this.config).getTopicResolver();
            List partitions = options.topicPartitions().stream().map(arg_0 -> ((TopicResolver)resolver).resolveTopic(arg_0)).collect(Collectors.toList());
            resolvedOptions.topicPartitions(partitions);
        }
        return new ResolvingListConsumerGroupOffsetsResult((KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>)super.listConsumerGroupOffsets(((ResolvingAdminConfig)this.config).getGroupResolver().resolveGroup(groupId), resolvedOptions).partitionsToOffsetAndMetadata(), ((ResolvingAdminConfig)this.config).getTopicResolver());
    }

    @Override
    public ListConsumerGroupsResult listConsumerGroups(ListConsumerGroupsOptions options) {
        return new ResolvingListConsumerGroupsResult(super.listConsumerGroups(options), ((ResolvingAdminConfig)this.config).getGroupResolver());
    }

    @Override
    public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds, DeleteConsumerGroupsOptions options) {
        GroupResolver groupResolver = ((ResolvingAdminConfig)this.config).getGroupResolver();
        return new ResolvingDeleteConsumerGroupsResult(super.deleteConsumerGroups(groupResolver.resolveGroups(groupIds), options).deletedGroups(), groupResolver);
    }

    @Override
    public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions, DeleteConsumerGroupOffsetsOptions options) {
        TopicResolver topicResolver = ((ResolvingAdminConfig)this.config).getTopicResolver();
        return new ResolvingDeleteConsumerGroupOffsetsResult(super.deleteConsumerGroupOffsets(((ResolvingAdminConfig)this.config).getGroupResolver().resolveGroup(groupId), topicResolver.resolveTopicPartitions(partitions), options), topicResolver);
    }

    @Override
    public ElectLeadersResult electLeaders(ElectionType electionType, Set<TopicPartition> partitions, ElectLeadersOptions options) {
        this.operationNotSupported("electLeaders");
        return null;
    }

    @Override
    public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> reassignments, AlterPartitionReassignmentsOptions options) {
        this.operationNotSupported("alterPartitionReassignments");
        return null;
    }

    @Override
    public ListPartitionReassignmentsResult listPartitionReassignments(Optional<Set<TopicPartition>> partitions, ListPartitionReassignmentsOptions options) {
        this.operationNotSupported("listPartitionReassignments");
        return null;
    }

    @Override
    public RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String groupId, RemoveMembersFromConsumerGroupOptions options) {
        return super.removeMembersFromConsumerGroup(((ResolvingAdminConfig)this.config).getGroupResolver().resolveGroup(groupId), options);
    }

    @Override
    public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets, AlterConsumerGroupOffsetsOptions options) {
        TopicResolver topicResolver = ((ResolvingAdminConfig)this.config).getTopicResolver();
        return new ResolvingAlterConsumerGroupOffsetsResult(super.alterConsumerGroupOffsets(((ResolvingAdminConfig)this.config).getGroupResolver().resolveGroup(groupId), topicResolver.resolveTopics(offsets), options), topicResolver);
    }

    @Override
    public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets, ListOffsetsOptions options) {
        TopicResolver topicResolver = ((ResolvingAdminConfig)this.config).getTopicResolver();
        return new ResolvingListOffsetsResult(super.listOffsets(topicResolver.resolveTopics(topicPartitionOffsets), options), topicResolver);
    }

    @Override
    public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
        this.operationNotSupported("describeClientQuotas");
        return null;
    }

    @Override
    public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> entries, AlterClientQuotasOptions options) {
        this.operationNotSupported("alterClientQuotas");
        return null;
    }
}

