/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.admin;

import io.axual.client.proxy.resolving.admin.ResolverUtil;
import io.axual.common.resolver.TopicResolver;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.ExtendableDescribeTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;

public class ResolvingDescribeTopicsResult
extends ExtendableDescribeTopicsResult {
    private final TopicResolver resolver;

    public ResolvingDescribeTopicsResult(Map<String, KafkaFuture<TopicDescription>> futures, TopicResolver resolver) {
        super(ResolverUtil.unresolve(futures, resolver));
        this.resolver = resolver;
    }

    public Map<String, KafkaFuture<TopicDescription>> values() {
        return this.convertFuture(super.values());
    }

    public KafkaFuture<Map<String, TopicDescription>> all() {
        return super.all().thenApply(this::convertResult);
    }

    private Map<String, KafkaFuture<TopicDescription>> convertFuture(Map<String, KafkaFuture<TopicDescription>> values) {
        HashMap<String, KafkaFuture<TopicDescription>> result = new HashMap<String, KafkaFuture<TopicDescription>>();
        for (Map.Entry<String, KafkaFuture<TopicDescription>> entry : values.entrySet()) {
            result.put(entry.getKey(), (KafkaFuture<TopicDescription>)entry.getValue().thenApply(this::unresolveTopicDescription));
        }
        return result;
    }

    private Map<String, TopicDescription> convertResult(Map<String, TopicDescription> values) {
        HashMap<String, TopicDescription> result = new HashMap<String, TopicDescription>();
        for (Map.Entry<String, TopicDescription> entry : values.entrySet()) {
            result.put(entry.getKey(), this.unresolveTopicDescription(entry.getValue()));
        }
        return result;
    }

    private TopicDescription unresolveTopicDescription(TopicDescription td) {
        return new TopicDescription(this.resolver.unresolveTopic(td.name()), td.isInternal(), td.partitions(), td.authorizedOperations());
    }
}

