/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.switching.consumer;

import java.util.Collection;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;

public abstract class Subscription<K, V> {
    private final ConsumerRebalanceListener listener;

    public Subscription(ConsumerRebalanceListener listener) {
        this.listener = listener;
    }

    public abstract void subscribe(Consumer<K, V> var1, boolean var2);

    protected ConsumerRebalanceListener getListener(final Consumer<K, V> consumer, final boolean seekToEnd) {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> collection) {
                if (Subscription.this.listener != null) {
                    Subscription.this.listener.onPartitionsRevoked(collection);
                }
            }

            public void onPartitionsAssigned(Collection<TopicPartition> collection) {
                if (seekToEnd) {
                    consumer.seekToEnd(collection);
                }
                if (Subscription.this.listener != null) {
                    Subscription.this.listener.onPartitionsAssigned(collection);
                }
            }
        };
    }
}

