/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.switching.producer;

import io.axual.client.proxy.generic.producer.ExtendedProducerRecord;
import io.axual.client.proxy.generic.producer.ProducerProxy;
import io.axual.client.proxy.generic.tools.SerdeUtil;
import io.axual.client.proxy.switching.discovery.DiscoverySubscriber;
import io.axual.client.proxy.switching.generic.SwitchingProxy;
import io.axual.client.proxy.switching.producer.ProducerSwitcher;
import io.axual.client.proxy.switching.producer.SwitchingProducerConfig;
import io.axual.client.proxy.switching.producer.TransactionSwitchedException;
import io.axual.common.concurrent.LockedObject;
import io.axual.common.tools.MapUtil;
import io.axual.discovery.client.tools.DiscoveryConfigParserV2;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.serialization.Serializer;

public class SwitchingProducer<K, V>
extends SwitchingProxy<ProducerProxy<K, V>, SwitchingProducerConfig<K, V>>
implements ProducerProxy<K, V> {
    private boolean transactionsInited = false;

    public SwitchingProducer(Map<String, Object> configs) {
        super(new SwitchingProducerConfig(configs), new DiscoverySubscriber(new DiscoveryConfigParserV2().parse(configs), SwitchingProducer.class.getSimpleName(), new ProducerSwitcher(), false));
    }

    public SwitchingProducer(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(SerdeUtil.addSerializersToConfigs(configs, keySerializer, valueSerializer));
    }

    public SwitchingProducer(Properties properties) {
        this(MapUtil.objectToStringMap((Map)properties));
    }

    public SwitchingProducer(Properties properties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(MapUtil.objectToStringMap((Map)properties), keySerializer, valueSerializer);
    }

    public void initTransactions() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ProducerProxy)lock.object).initTransactions();
        }
        this.transactionsInited = true;
    }

    public void beginTransaction() {
        if (this.maybeReplaceProxiedObject(false) && this.transactionsInited) {
            this.initTransactions();
        }
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ProducerProxy)lock.object).beginTransaction();
        }
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) {
        if (this.transactionsInited && this.maybeReplaceProxiedObject(false, this.transactionsInited)) {
            this.initTransactions();
            throw new TransactionSwitchedException("Producer switched to a new cluster. You need to start the transaction again.");
        }
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ProducerProxy)lock.object).sendOffsetsToTransaction(offsets, consumerGroupId);
        }
    }

    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        if (this.transactionsInited && this.maybeReplaceProxiedObject(false, this.transactionsInited)) {
            this.initTransactions();
            throw new TransactionSwitchedException("Producer switched to a new cluster. You need to start the transaction again.");
        }
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ProducerProxy)lock.object).sendOffsetsToTransaction(offsets, groupMetadata);
        }
    }

    public void commitTransaction() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ProducerProxy)lock.object).commitTransaction();
        }
    }

    public void abortTransaction() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ProducerProxy)lock.object).abortTransaction();
        }
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        if (this.maybeReplaceProxiedObject(false, this.transactionsInited) && this.transactionsInited) {
            this.initTransactions();
            throw new TransactionSwitchedException("Producer switched to a new cluster. You need to start the transaction again.");
        }
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Future future = ((ProducerProxy)lock.object).send(this.convertProducerRecord(record));
            return future;
        }
    }

    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        if (this.maybeReplaceProxiedObject(false, this.transactionsInited) && this.transactionsInited) {
            this.initTransactions();
            throw new TransactionSwitchedException("Producer switched to a new cluster. You need to start the transaction again.");
        }
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Future future = ((ProducerProxy)lock.object).send(this.convertProducerRecord(record), callback);
            return future;
        }
    }

    public void flush() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            ((ProducerProxy)lock.object).flush();
        }
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            List list = ((ProducerProxy)lock.object).partitionsFor(topic);
            return list;
        }
    }

    public Map<MetricName, ? extends Metric> metrics() {
        try (LockedObject.ReadLock lock = this.getReadLock();){
            Map map = ((ProducerProxy)lock.object).metrics();
            return map;
        }
    }

    private ExtendedProducerRecord<K, V> convertProducerRecord(ProducerRecord<K, V> record) {
        if (record instanceof ExtendedProducerRecord) {
            ExtendedProducerRecord extendedRecord = (ExtendedProducerRecord)record;
            MapUtil.putAllIfAbsent(extendedRecord.context(), (Map)this.getCurrentDiscoveryResult().getConfigs());
            return extendedRecord;
        }
        return new ExtendedProducerRecord<Object, Object>(record.topic(), record.partition(), record.timestamp(), record.key(), record.value(), (Iterable<Header>)record.headers(), new HashMap<String, Object>(this.getCurrentDiscoveryResult().getConfigs()));
    }
}

