/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.wrapped.serde;

import io.axual.client.proxy.generic.proxy.BaseSerdeConfig;
import io.axual.client.proxy.generic.serde.DeserializerProxyFactory;
import io.axual.client.proxy.generic.serde.SerializerProxyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;

public class WrappedSerializerConfig<T>
extends BaseSerdeConfig {
    public static final String SERIALIZER_CONFIG = "wrappedserializer.serializer";
    private final Serializer<T> serializer;

    public WrappedSerializerConfig(Map<String, ?> configs, boolean isKey) {
        super(configs, isKey);
        this.filterDownstream(new String[]{SERIALIZER_CONFIG});
        Object serializerConfig = configs.get("wrappeddeserializer.deserializer");
        if (serializerConfig instanceof DeserializerProxyFactory) {
            this.serializer = ((SerializerProxyFactory)serializerConfig).create(new HashMap<String, Object>(this.getDownstreamConfigs()), isKey);
        } else {
            this.serializer = (Serializer)this.getConfiguredInstance(SERIALIZER_CONFIG, Serializer.class);
            this.serializer.configure(this.getDownstreamConfigs(), isKey);
        }
    }

    public Serializer<T> getSerializer() {
        return this.serializer;
    }
}

