/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.axual.generic;

import io.axual.client.proxy.generic.client.ClientProxy;
import io.axual.client.proxy.generic.config.BaseClientProxyConfig;
import io.axual.client.proxy.generic.registry.ProxyChain;
import io.axual.client.proxy.generic.registry.ProxyChainUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AxualProxyConfig<T extends ClientProxy>
extends BaseClientProxyConfig<T> {
    private static final ConcurrentHashMap<String, AtomicInteger> clientIdCounters = new ConcurrentHashMap();
    private final String applicationId;
    private final ProxyChain proxyChain;
    private final String proxyType;

    public AxualProxyConfig(Map<String, Object> configs, String proxyType, String backingFactoryConfigKey, String chainConfigKey) {
        super(configs, backingFactoryConfigKey);
        this.filterDownstream(new String[]{chainConfigKey});
        this.proxyType = proxyType;
        this.applicationId = this.parseStringConfig("app.id", true, null);
        this.proxyChain = ProxyChainUtil.parseProxyChain(configs, chainConfigKey);
        this.putDownstream("client.id", this.generateNewClientId());
    }

    protected static Map<String, Object> addDefaultFactory(Map<String, Object> configs, String backingFactoryConfigKey, Object defaultValue) {
        HashMap<String, Object> result = new HashMap<String, Object>(configs);
        result.putIfAbsent(backingFactoryConfigKey, defaultValue);
        return result;
    }

    public ProxyChain getProxyChain() {
        return this.proxyChain;
    }

    private String generateNewClientId() {
        String clientName = this.proxyType + "-" + this.applicationId;
        clientIdCounters.putIfAbsent(clientName, new AtomicInteger(0));
        AtomicInteger counter = clientIdCounters.get(clientName);
        return clientName + "-" + counter.incrementAndGet();
    }

    public String getApplicationId() {
        return this.applicationId;
    }
}

