/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.axual.serde;

import io.axual.client.proxy.axual.serde.AxualDeserializerConfig;
import io.axual.client.proxy.generic.registry.ProxyChainUtil;
import io.axual.client.proxy.generic.serde.BaseDeserializerProxy;
import io.axual.client.proxy.generic.serde.DeserializerProxyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;

public class AxualDeserializer<T>
extends BaseDeserializerProxy<T, AxualDeserializerConfig<T>> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new AxualDeserializerConfig(new HashMap<String, Object>(configs), isKey));
        HashMap<String, Object> deserializerConfigs = new HashMap<String, Object>(configs);
        Object defaultDeserializer = configs.get("axualdeserializer.default.deserializer");
        deserializerConfigs.put("wrappeddeserializer.deserializer", defaultDeserializer);
        DeserializerProxyFactory factory = ProxyChainUtil.setupDeserializerFactoryChain(((AxualDeserializerConfig)this.config).getProxyChain());
        this.backingDeserializer = factory.create(deserializerConfigs, isKey);
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        return (T)this.backingDeserializer.deserialize(topic, headers, data);
    }
}

