/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.generic.client;

import io.axual.client.proxy.generic.client.BaseClientProxy;
import io.axual.client.proxy.generic.client.ClientProxy;
import io.axual.client.proxy.generic.client.ClientProxyReplacer;
import io.axual.client.proxy.generic.config.BaseClientProxyConfig;
import io.axual.client.proxy.generic.config.DynamicClientProxyConfig;
import io.axual.client.proxy.generic.producer.ProducerProxy;
import io.axual.common.concurrent.LockedObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicClientProxy<T extends ClientProxy, C extends DynamicClientProxyConfig>
extends BaseClientProxy<C> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicClientProxy.class);
    private final LockedObject<T> lockedProxy;
    private final ClientProxyReplacer<T, C> replacer;

    public DynamicClientProxy(C config, ClientProxyReplacer<T, C> replacer) {
        super(config);
        this.replacer = replacer;
        this.lockedProxy = this.initializeProxiedObject();
    }

    @Override
    public Map<String, Object> getConfigs() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (LockedObject.ReadLock lock = this.getReadLock();){
            if (lock.object != null) {
                Map<String, Object> configs = ((ClientProxy)lock.object).getConfigs();
                result.putAll(configs);
            }
        }
        result.putAll(super.getConfigs());
        return result;
    }

    @Override
    public final Object getConfig(String key) {
        Object result = super.getConfig(key);
        if (result == null) {
            try (LockedObject.ReadLock lock = this.getReadLock();){
                if (lock.object != null) {
                    result = ((ClientProxy)lock.object).getConfig(key);
                }
            }
        }
        return result;
    }

    @Deprecated
    public final void close(long timeout, TimeUnit unit) {
        this.close(Duration.ofMillis(unit.toMillis(timeout)));
    }

    @Override
    public void close(Duration timeout) {
        this.replacer.close();
        try (LockedObject.WriteLock lock = this.getWriteLock();){
            if (lock.getObject() != null) {
                ((ClientProxy)lock.getObject()).close();
                lock.setObject(null);
            }
        }
        super.close(timeout);
    }

    private LockedObject<T> initializeProxiedObject() {
        try {
            return new LockedObject(this.replacer.replace(null, (BaseClientProxyConfig)this.config));
        }
        catch (Exception e) {
            LOG.error("Exception occurred while initializing {}", (Object)((DynamicClientProxyConfig)this.config).getProxyType(), (Object)e);
            throw e;
        }
    }

    protected synchronized boolean maybeReplaceProxiedObject(boolean force) {
        return this.maybeReplaceProxiedObject(force, false);
    }

    protected synchronized boolean maybeReplaceProxiedObject(boolean force, boolean isTransactional) {
        boolean needToReplace = this.replacer.needToReplace();
        if (needToReplace) {
            LOG.info("Something changed, replacing backing {}", (Object)((DynamicClientProxyConfig)this.config).getProxyType());
        }
        if (force) {
            LOG.info("Forcefully replacing backing {}", (Object)((DynamicClientProxyConfig)this.config).getProxyType());
        }
        if (needToReplace || force) {
            this.replaceProxiedObject(isTransactional);
            return true;
        }
        return false;
    }

    private void replaceProxiedObject(boolean isTransactional) {
        try (LockedObject.WriteLock lock = this.getWriteLock();){
            ClientProxy object;
            if (isTransactional && ProducerProxy.class.isAssignableFrom((object = (ClientProxy)lock.getObject()).getClass())) {
                this.silentlyAbortTransactions((ProducerProxy)object);
            }
            lock.setObject((Object)this.replacer.replace((ClientProxy)lock.getObject(), (BaseClientProxyConfig)this.config));
        }
        catch (Exception e) {
            LOG.error("Exception occurred while switching backing {}", (Object)((DynamicClientProxyConfig)this.config).getProxyType(), (Object)e);
        }
    }

    private void silentlyAbortTransactions(ProducerProxy producerProxy) {
        try {
            producerProxy.abortTransaction();
        }
        catch (IllegalStateException e) {
            LOG.info("Tried to silently abort transaction, but probably none active: {}", (Object)e.getMessage());
        }
    }

    protected LockedObject.ReadLock getReadLock() {
        return this.lockedProxy.getReadLock();
    }

    protected LockedObject.WriteLock getWriteLock() {
        return this.lockedProxy.getWriteLock();
    }
}

