/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.generic.client;

import io.axual.client.proxy.generic.client.BaseClientProxy;
import io.axual.client.proxy.generic.client.ClientProxy;
import io.axual.client.proxy.generic.client.ClientProxyFactory;
import io.axual.client.proxy.generic.config.BaseClientProxyConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class StaticClientProxy<T extends ClientProxy, C extends BaseClientProxyConfig<T>>
extends BaseClientProxy<C> {
    protected final T proxiedObject;
    private boolean closed = false;

    public StaticClientProxy(C config) {
        super(config);
        ClientProxyFactory factory = ((BaseClientProxyConfig)((Object)config)).getBackingFactory();
        if (factory == null) {
            factory = ((BaseClientProxyConfig)((Object)config)).getBackingFactory();
        }
        this.proxiedObject = (ClientProxy)factory.create(config.getDownstreamConfigs());
    }

    public StaticClientProxy(ClientProxyInitializer<T, C> initializer) {
        super(((ClientProxyInitializer)initializer).config);
        this.proxiedObject = ((ClientProxyInitializer)initializer).proxiedObject;
        this.initialize(initializer);
    }

    protected void initialize(ClientProxyInitializer<T, C> initializer) {
    }

    @Override
    public Map<String, Object> getConfigs() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.proxiedObject.getConfigs());
        result.putAll(super.getConfigs());
        return result;
    }

    @Override
    public Object getConfig(String key) {
        Object result = super.getConfig(key);
        if (result == null) {
            result = this.proxiedObject.getConfig(key);
        }
        return result;
    }

    @Deprecated
    public final void close(long timeout, TimeUnit unit) {
        this.close(Duration.ofMillis(unit.toMillis(timeout)));
    }

    @Override
    public void close(Duration timeout) {
        if (!this.closed) {
            this.closed = true;
            this.proxiedObject.close(timeout);
        }
    }

    public static class ClientProxyInitializer<T extends ClientProxy, C extends BaseClientProxyConfig> {
        private final C config;
        private final T proxiedObject;

        public ClientProxyInitializer(C config, T proxiedObject) {
            this.config = config;
            this.proxiedObject = proxiedObject;
        }
    }
}

