/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.generic.registry;

import io.axual.client.proxy.generic.registry.ProxyChainElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProxyChain {
    private static final String PROXY_SEPARATOR = ";";
    private static final String PROXY_ID_CONFIGS_SEPARATOR = ":";
    private static final String PROXY_CONFIG_SEPARATOR = ",";
    private static final String PROXY_CONFIG_KEY_VALUE_SEPARATOR = "=";
    private final List<ProxyChainElement> elements;

    private ProxyChain(Builder builder) {
        this(builder.elements);
    }

    public ProxyChain(List<ProxyChainElement> elements) {
        this.elements = Collections.unmodifiableList(elements);
    }

    public boolean containsElement(String proxyType) {
        for (ProxyChainElement element : this.elements) {
            if (!element.getProxyId().equals(proxyType)) continue;
            return true;
        }
        return false;
    }

    public List<ProxyChainElement> getElements() {
        return this.elements;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ProxyChainElement element : this.elements) {
            if (builder.length() > 0) {
                builder.append(PROXY_SEPARATOR);
            }
            builder.append(element.getProxyId());
            if (element.getConfigs() == null || element.getConfigs().size() <= 0) continue;
            builder.append(PROXY_ID_CONFIGS_SEPARATOR);
            boolean firstConfig = true;
            for (Map.Entry<String, Object> entry : element.getConfigs().entrySet()) {
                if (!firstConfig) {
                    builder.append(PROXY_CONFIG_SEPARATOR);
                } else {
                    firstConfig = false;
                }
                builder.append(entry.getKey());
                builder.append(PROXY_CONFIG_KEY_VALUE_SEPARATOR);
                builder.append(entry.getValue());
            }
        }
        return builder.toString();
    }

    public static ProxyChain parse(String chainStr) {
        ArrayList<ProxyChainElement> elements = new ArrayList<ProxyChainElement>();
        if (chainStr != null) {
            for (String elementStr : chainStr.split(PROXY_SEPARATOR)) {
                String[] proxyStr = elementStr.split(PROXY_ID_CONFIGS_SEPARATOR);
                if (proxyStr.length < 1) continue;
                HashMap<String, Object> configs = proxyStr.length >= 2 ? ProxyChain.parseChainElementConfigs(proxyStr[1]) : new HashMap();
                elements.add(ProxyChainElement.newBuilder().setProxyId(proxyStr[0]).setConfigs(configs).build());
            }
        }
        return new ProxyChain(elements);
    }

    private static Map<String, Object> parseChainElementConfigs(String configs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String config : configs.split(PROXY_CONFIG_SEPARATOR)) {
            String key = config.substring(0, config.indexOf(PROXY_CONFIG_KEY_VALUE_SEPARATOR));
            String value = config.substring(key.length() + 1);
            result.put(key, value);
        }
        return result;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ProxyChain fromChain) {
        return new Builder(fromChain);
    }

    public static class Builder {
        private final List<ProxyChainElement> elements = new ArrayList<ProxyChainElement>();

        public Builder() {
        }

        public Builder(ProxyChain fromChain) {
            this.elements.addAll(fromChain.elements);
        }

        public Builder append(ProxyChainElement element) {
            this.elements.add(element);
            return this;
        }

        public Builder append(String proxyType) {
            this.elements.add(ProxyChainElement.newBuilder().setProxyId(proxyType).setConfigs(new HashMap<String, Object>()).build());
            return this;
        }

        public Builder append(String proxyType, Map<String, Object> configs) {
            this.elements.add(ProxyChainElement.newBuilder().setProxyId(proxyType).setConfigs(configs).build());
            return this;
        }

        public Builder filter(Filter filter) {
            ArrayList<ProxyChainElement> newElements = new ArrayList<ProxyChainElement>(this.elements.size());
            for (ProxyChainElement element : this.elements) {
                if (!filter.filter(element)) continue;
                newElements.add(element);
            }
            this.elements.clear();
            this.elements.addAll(newElements);
            return this;
        }

        public Builder remove(String proxyId) {
            return this.filter(element -> !element.getProxyId().equals(proxyId));
        }

        public ProxyChain build() {
            return new ProxyChain(this);
        }
    }

    public static interface Filter {
        public boolean filter(ProxyChainElement var1);
    }
}

