/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.generic.registry;

import io.axual.client.proxy.exception.ProxyTypeNotRegistered;
import io.axual.client.proxy.generic.admin.AdminProxy;
import io.axual.client.proxy.generic.admin.AdminProxyFactory;
import io.axual.client.proxy.generic.client.ClientProxy;
import io.axual.client.proxy.generic.client.ClientProxyFactory;
import io.axual.client.proxy.generic.consumer.ConsumerProxy;
import io.axual.client.proxy.generic.consumer.ConsumerProxyFactory;
import io.axual.client.proxy.generic.producer.ProducerProxy;
import io.axual.client.proxy.generic.producer.ProducerProxyFactory;
import io.axual.client.proxy.generic.registry.ProxyChain;
import io.axual.client.proxy.generic.registry.ProxyChainElement;
import io.axual.client.proxy.generic.registry.ProxyTypeRegistry;
import io.axual.client.proxy.generic.serde.DeserializerProxy;
import io.axual.client.proxy.generic.serde.DeserializerProxyFactory;
import io.axual.client.proxy.generic.serde.SerializerProxy;
import io.axual.client.proxy.generic.serde.SerializerProxyFactory;
import io.axual.client.proxy.wrapped.admin.WrappedAdminClientFactory;
import io.axual.client.proxy.wrapped.consumer.WrappedConsumerFactory;
import io.axual.client.proxy.wrapped.producer.WrappedProducerFactory;
import io.axual.client.proxy.wrapped.serde.WrappedDeserializerFactory;
import io.axual.client.proxy.wrapped.serde.WrappedSerializerFactory;
import io.axual.common.exception.PropertyNotSetException;
import io.axual.common.tools.FactoryUtil;
import java.util.HashMap;
import java.util.Map;

public class ProxyChainUtil {
    private ProxyChainUtil() {
    }

    private static <T extends ClientProxy, F extends ClientProxyFactory<T>> ClientProxyFactory<T> prependClientProxyFactory(String factoryClassName, Class<F> factoryClass, Map<String, Object> injectedConfig, String backingFactoryPropertyName, ClientProxyFactory<T> lastFactory) {
        ClientProxyFactory prependedFactory = (ClientProxyFactory)FactoryUtil.create((String)factoryClassName, factoryClass);
        injectedConfig = injectedConfig != null ? new HashMap<String, Object>(injectedConfig) : new HashMap();
        injectedConfig.put(backingFactoryPropertyName, lastFactory);
        return new ConfigInjectingClientProxyFactory(injectedConfig, prependedFactory);
    }

    private static <T, F extends DeserializerProxyFactory<T>> DeserializerProxyFactory<T> prependDeserializerProxyFactory(String factoryClassName, Class<F> factoryClass, Map<String, Object> injectedConfig, String backingFactoryPropertyName, DeserializerProxyFactory<T> lastFactory) {
        DeserializerProxyFactory prependedFactory = (DeserializerProxyFactory)FactoryUtil.create((String)factoryClassName, factoryClass);
        injectedConfig = injectedConfig != null ? new HashMap<String, Object>(injectedConfig) : new HashMap();
        injectedConfig.put(backingFactoryPropertyName, lastFactory);
        return new ConfigInjectingDeserializerProxyFactory(injectedConfig, prependedFactory);
    }

    private static <T, F extends SerializerProxyFactory<T>> SerializerProxyFactory<T> prependSerdeProxyFactory(String factoryClassName, Class<F> factoryClass, Map<String, Object> injectedConfig, String backingFactoryPropertyName, SerializerProxyFactory<T> lastFactory) {
        SerializerProxyFactory prependedFactory = (SerializerProxyFactory)FactoryUtil.create((String)factoryClassName, factoryClass);
        injectedConfig = injectedConfig != null ? new HashMap<String, Object>(injectedConfig) : new HashMap();
        injectedConfig.put(backingFactoryPropertyName, lastFactory);
        return new ConfigInjectingSerializerProxyFactory(injectedConfig, prependedFactory);
    }

    public static ProxyChain parseProxyChain(Map<String, ?> configs, String chainPropertyName) {
        Object chainConfig = configs.get(chainPropertyName);
        if (chainConfig instanceof String) {
            return ProxyChain.parse((String)chainConfig);
        }
        if (chainConfig instanceof ProxyChain) {
            return (ProxyChain)chainConfig;
        }
        throw new PropertyNotSetException(chainPropertyName);
    }

    public static ClientProxyFactory<AdminProxy> setupAdminFactoryChain(ProxyChain chain) {
        return ProxyChainUtil.setupAdminFactoryChain(chain, new WrappedAdminClientFactory());
    }

    public static ClientProxyFactory<AdminProxy> setupAdminFactoryChain(ProxyChain chain, ClientProxyFactory<AdminProxy> lastFactory) {
        for (int index = chain.getElements().size() - 1; index >= 0; --index) {
            lastFactory = ProxyChainUtil.prependAdminFactoryForElement(lastFactory, chain.getElements().get(index));
        }
        return lastFactory;
    }

    public static ClientProxyFactory<AdminProxy> prependAdminFactoryForElement(ClientProxyFactory<AdminProxy> lastFactory, ProxyChainElement element) {
        ProxyTypeRegistry.ProxyTypeRegistration reg = ProxyTypeRegistry.getProxyRegistration(ProxyTypeRegistry.ProxyType.ADMIN, element.getProxyId());
        if (reg == null) {
            throw new ProxyTypeNotRegistered("admin", element.getProxyId());
        }
        return ProxyChainUtil.prependClientProxyFactory(reg.getBackingClassName(), AdminProxyFactory.class, element.getConfigs(), reg.getBackingPropertyName(), lastFactory);
    }

    public static <K, V> ClientProxyFactory<ConsumerProxy<K, V>> setupConsumerFactoryChain(ProxyChain chain) {
        return ProxyChainUtil.setupConsumerFactoryChain(chain, new WrappedConsumerFactory());
    }

    public static <K, V> ClientProxyFactory<ConsumerProxy<K, V>> setupConsumerFactoryChain(ProxyChain chain, ClientProxyFactory<ConsumerProxy<K, V>> lastFactory) {
        for (int index = chain.getElements().size() - 1; index >= 0; --index) {
            lastFactory = ProxyChainUtil.prependConsumerFactoryForElement(lastFactory, chain.getElements().get(index));
        }
        return lastFactory;
    }

    public static <K, V> ClientProxyFactory<ConsumerProxy<K, V>> prependConsumerFactoryForElement(ClientProxyFactory<ConsumerProxy<K, V>> lastFactory, ProxyChainElement element) {
        ProxyTypeRegistry.ProxyTypeRegistration reg = ProxyTypeRegistry.getProxyRegistration(ProxyTypeRegistry.ProxyType.CONSUMER, element.getProxyId());
        if (reg == null) {
            throw new ProxyTypeNotRegistered("consumer", element.getProxyId());
        }
        return ProxyChainUtil.prependClientProxyFactory(reg.getBackingClassName(), ConsumerProxyFactory.class, element.getConfigs(), reg.getBackingPropertyName(), lastFactory);
    }

    public static <K, V> ClientProxyFactory<ProducerProxy<K, V>> setupProducerFactoryChain(ProxyChain chain) {
        return ProxyChainUtil.setupProducerFactoryChain(chain, new WrappedProducerFactory());
    }

    public static <K, V> ClientProxyFactory<ProducerProxy<K, V>> setupProducerFactoryChain(ProxyChain chain, ClientProxyFactory<ProducerProxy<K, V>> lastFactory) {
        for (int index = chain.getElements().size() - 1; index >= 0; --index) {
            lastFactory = ProxyChainUtil.prependProducerFactoryForElement(lastFactory, chain.getElements().get(index));
        }
        return lastFactory;
    }

    public static <K, V> ClientProxyFactory<ProducerProxy<K, V>> prependProducerFactoryForElement(ClientProxyFactory<ProducerProxy<K, V>> lastFactory, ProxyChainElement element) {
        ProxyTypeRegistry.ProxyTypeRegistration reg = ProxyTypeRegistry.getProxyRegistration(ProxyTypeRegistry.ProxyType.PRODUCER, element.getProxyId());
        if (reg == null) {
            throw new ProxyTypeNotRegistered("producer", element.getProxyId());
        }
        return ProxyChainUtil.prependClientProxyFactory(reg.getBackingClassName(), ProducerProxyFactory.class, element.getConfigs(), reg.getBackingPropertyName(), lastFactory);
    }

    public static <T> DeserializerProxyFactory<T> setupDeserializerFactoryChain(ProxyChain chain) {
        DeserializerProxyFactory lastFactory = new WrappedDeserializerFactory();
        for (int index = chain.getElements().size() - 1; index >= 0; --index) {
            lastFactory = ProxyChainUtil.prependDeserializerForElement(lastFactory, chain.getElements().get(index));
        }
        return lastFactory;
    }

    public static <T> DeserializerProxyFactory<T> prependDeserializerForElement(DeserializerProxyFactory<T> lastFactory, ProxyChainElement element) {
        ProxyTypeRegistry.ProxyTypeRegistration reg = ProxyTypeRegistry.getProxyRegistration(ProxyTypeRegistry.ProxyType.DESERIALIZER, element.getProxyId());
        if (reg == null) {
            throw new ProxyTypeNotRegistered("deserializer", element.getProxyId());
        }
        return ProxyChainUtil.prependDeserializerProxyFactory(reg.getBackingClassName(), DeserializerProxyFactory.class, element.getConfigs(), reg.getBackingPropertyName(), lastFactory);
    }

    public static <T> SerializerProxyFactory<T> setupSerializerFactoryChain(ProxyChain chain) {
        SerializerProxyFactory lastFactory = new WrappedSerializerFactory();
        for (int index = chain.getElements().size() - 1; index >= 0; --index) {
            lastFactory = ProxyChainUtil.prependSerializerForElement(lastFactory, chain.getElements().get(index));
        }
        return lastFactory;
    }

    public static <T> SerializerProxyFactory<T> prependSerializerForElement(SerializerProxyFactory<T> lastFactory, ProxyChainElement element) {
        ProxyTypeRegistry.ProxyTypeRegistration reg = ProxyTypeRegistry.getProxyRegistration(ProxyTypeRegistry.ProxyType.SERIALIZER, element.getProxyId());
        if (reg == null) {
            throw new ProxyTypeNotRegistered("serializer", element.getProxyId());
        }
        return ProxyChainUtil.prependSerdeProxyFactory(reg.getBackingClassName(), SerializerProxyFactory.class, element.getConfigs(), reg.getBackingPropertyName(), lastFactory);
    }

    private static class ConfigInjectingSerializerProxyFactory<T>
    implements SerializerProxyFactory<T> {
        private final Map<String, Object> configs;
        private final SerializerProxyFactory<T> factory;

        private ConfigInjectingSerializerProxyFactory(Map<String, Object> configs, SerializerProxyFactory<T> factory) {
            this.configs = configs;
            this.factory = factory;
        }

        @Override
        public SerializerProxy<T> create(Map<String, Object> configs, boolean isKey) {
            HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
            if (this.configs != null) {
                newConfigs.putAll(this.configs);
            }
            return this.factory.create(newConfigs, isKey);
        }
    }

    private static class ConfigInjectingDeserializerProxyFactory<T>
    implements DeserializerProxyFactory<T> {
        private final Map<String, Object> configs;
        private final DeserializerProxyFactory<T> factory;

        private ConfigInjectingDeserializerProxyFactory(Map<String, Object> configs, DeserializerProxyFactory<T> factory) {
            this.configs = configs;
            this.factory = factory;
        }

        @Override
        public DeserializerProxy<T> create(Map<String, Object> configs, boolean isKey) {
            HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
            if (this.configs != null) {
                newConfigs.putAll(this.configs);
            }
            return this.factory.create(newConfigs, isKey);
        }
    }

    private static class ConfigInjectingClientProxyFactory<T extends ClientProxy>
    implements ClientProxyFactory<T> {
        private final Map<String, Object> configs;
        private final ClientProxyFactory<T> factory;

        private ConfigInjectingClientProxyFactory(Map<String, Object> configs, ClientProxyFactory<T> factory) {
            this.configs = configs;
            this.factory = factory;
        }

        @Override
        public T create(Map<String, Object> configs) {
            HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
            if (this.configs != null) {
                newConfigs.putAll(this.configs);
            }
            return (T)((ClientProxy)this.factory.create(newConfigs));
        }
    }
}

