/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.header.serde;

import io.axual.client.proxy.exception.DuplicateValueHeaderException;
import io.axual.client.proxy.generic.serde.BaseSerializerProxy;
import io.axual.client.proxy.header.serde.HeaderSerializerConfig;
import io.axual.serde.utils.HeaderUtils;
import io.axual.serde.utils.SerdeUtils;
import io.axual.serde.valueheader.ValueHeader;
import io.axual.serde.valueheader.ValueHeaderSerializer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderSerializer<T>
extends BaseSerializerProxy<T, HeaderSerializerConfig<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderSerializer.class);
    private ValueHeaderSerializer valueHeaderSerializer;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new HeaderSerializerConfig(new HashMap<String, Object>(configs), isKey));
        this.valueHeaderSerializer = new ValueHeaderSerializer();
        this.valueHeaderSerializer.configure(((HeaderSerializerConfig)this.config).getDownstreamConfigs(), isKey);
    }

    @Override
    public byte[] serialize(String topic, T object) {
        return this.serialize(topic, null, object);
    }

    public byte[] serialize(String topic, Headers headers, T object) {
        byte[] bodyData = this.backingSerializer.serialize(topic, headers, object);
        if (!((HeaderSerializerConfig)this.config).isKey() && ((HeaderSerializerConfig)this.config).valueHeadersEnabled()) {
            HeaderSerializer.ensureNoValueHeaders(object);
            ValueHeader valueHeader = headers != null ? HeaderSerializer.deriveFromLineageHeaders(headers) : new ValueHeader();
            byte[] headerData = this.valueHeaderSerializer.serialize(topic, valueHeader);
            if (bodyData == null) {
                return headerData;
            }
            byte[] result = new byte[headerData.length + bodyData.length];
            System.arraycopy(headerData, 0, result, 0, headerData.length);
            System.arraycopy(bodyData, 0, result, headerData.length, bodyData.length);
            return result;
        }
        return bodyData;
    }

    public static ValueHeader deriveFromLineageHeaders(Headers headers) {
        UUID messageId = HeaderUtils.decodeUuidHeader((Header)headers.lastHeader("Axual-Message-Id"));
        Long serializationTime = HeaderUtils.decodeLongHeader((Header)headers.lastHeader("Axual-Serialization-Time"));
        Integer copyFlags = HeaderUtils.decodeIntegerHeader((Header)headers.lastHeader("Axual-Copy-Flags"));
        return new ValueHeader(messageId != null ? messageId : UUID.randomUUID(), Long.valueOf(serializationTime != null ? serializationTime : System.currentTimeMillis()), copyFlags != null ? (byte)(copyFlags & 0xFF) : (byte)0);
    }

    private static void ensureNoValueHeaders(Object object) {
        if (object instanceof byte[] && SerdeUtils.containsValueHeader((byte[])((byte[])object))) {
            LOG.error("Duplicate value header encoding!!");
            throw new DuplicateValueHeaderException("Found value headers in byte array to serialize");
        }
    }

    @Override
    public void close(Duration duration) {
        if (this.valueHeaderSerializer != null) {
            this.valueHeaderSerializer.close();
        }
        super.close(duration);
    }
}

