/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.lineage.consumer;

import io.axual.client.proxy.generic.consumer.StaticConsumerProxy;
import io.axual.client.proxy.generic.tools.SerdeUtil;
import io.axual.client.proxy.lineage.consumer.LineageConsumerConfig;
import io.axual.client.proxy.lineage.core.LineageAppender;
import io.axual.client.proxy.lineage.core.LineageConfig;
import io.axual.common.tools.MapUtil;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.serialization.Deserializer;

public class LineageConsumer<K, V>
extends StaticConsumerProxy<K, V, LineageConsumerConfig<K, V>> {
    private final LineageConfig lineageConfig;

    public LineageConsumer(Map<String, Object> configs) {
        super(new LineageConsumerConfig(configs));
        this.lineageConfig = new LineageConfig(configs);
    }

    public LineageConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(SerdeUtil.addDeserializersToConfigs(configs, keyDeserializer, valueDeserializer));
    }

    public LineageConsumer(Properties properties) {
        this(MapUtil.objectToStringMap((Map)properties));
    }

    public LineageConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(MapUtil.objectToStringMap((Map)properties), keyDeserializer, valueDeserializer);
    }

    @Override
    @Deprecated
    public ConsumerRecords<K, V> poll(long timeout) {
        return this.attachLineage(super.poll(timeout));
    }

    @Override
    public ConsumerRecords<K, V> poll(Duration timeout) {
        return this.attachLineage(super.poll(timeout));
    }

    private ConsumerRecords<K, V> attachLineage(ConsumerRecords<K, V> records) {
        for (ConsumerRecord record : records) {
            LineageAppender.appendLineageForDeserialization(record.headers(), this.lineageConfig);
        }
        return records;
    }
}

