/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.lineage.producer;

import io.axual.client.proxy.generic.producer.StaticProducerProxy;
import io.axual.client.proxy.generic.tools.SerdeUtil;
import io.axual.client.proxy.lineage.core.LineageAppender;
import io.axual.client.proxy.lineage.core.LineageConfig;
import io.axual.client.proxy.lineage.producer.LineageProducerConfig;
import io.axual.common.tools.MapUtil;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.Serializer;

public class LineageProducer<K, V>
extends StaticProducerProxy<K, V, LineageProducerConfig<K, V>> {
    private final LineageConfig lineageConfig;

    public LineageProducer(Map<String, Object> configs) {
        super(new LineageProducerConfig(configs));
        this.lineageConfig = new LineageConfig(configs);
    }

    public LineageProducer(Map<String, Object> configs, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(SerdeUtil.addSerializersToConfigs(configs, keySerializer, valueSerializer));
    }

    public LineageProducer(Properties properties) {
        this(MapUtil.objectToStringMap((Map)properties));
    }

    public LineageProducer(Properties properties, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(MapUtil.objectToStringMap((Map)properties), keySerializer, valueSerializer);
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> producerRecord) {
        LineageAppender.appendLineageForSerialization(producerRecord.headers(), this.lineageConfig);
        return super.send(producerRecord);
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> producerRecord, Callback callback) {
        LineageAppender.appendLineageForSerialization(producerRecord.headers(), this.lineageConfig);
        return super.send(producerRecord, callback);
    }
}

