/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.logging.core;

import io.axual.client.proxy.callback.core.MethodCall;
import io.axual.client.proxy.logging.core.LevelLogger;
import io.axual.client.proxy.logging.core.LoggingConfig;
import java.util.UUID;

public class LoggingMethodCall
implements MethodCall {
    private final LevelLogger log;
    private final String methodName;

    public LoggingMethodCall(LoggingConfig config, LevelLogger logger, UUID callId, String method) {
        if (config.getMethods().isEmpty() || config.getMethods().contains(method)) {
            this.log = logger;
            this.methodName = method + " (" + (config.getName() != null && config.getName().length() > 0 ? config.getName() + "," : "") + "id=" + callId.toString() + ")";
        } else {
            this.log = null;
            this.methodName = "";
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void onEnter(String[] paramNames, Object ... paramValues) {
        if (this.log != null) {
            String paramOutput = this.getParameterOutput(paramNames, paramValues);
            this.log.log("ENTER " + this.methodName + (paramOutput.length() > 0 ? ": " : "") + paramOutput);
        }
    }

    @Override
    public void onException(Throwable t) {
        if (this.log != null) {
            this.log.log("EXCEPTION IN " + this.methodName, t);
        }
    }

    @Override
    public void onResult(Object result) {
        if (this.log != null) {
            String resultStr = result != null ? "(" + result.getClass().getSimpleName() + ") " + result.toString() : "null";
            this.log.log("RETURN VALUE OF " + this.methodName + ": " + resultStr);
        }
    }

    @Override
    public void onExit() {
        if (this.log != null) {
            this.log.log("EXIT " + this.methodName);
        }
    }

    private String getParameterOutput(Object[] paramNames, Object[] paramValues) {
        StringBuilder result = new StringBuilder();
        if (paramValues != null) {
            for (int index = 0; index < paramValues.length; ++index) {
                if (index > 0) {
                    result.append(", ");
                }
                result.append(paramNames != null && paramNames.length > index ? paramNames[index] : "param" + index).append("=").append(paramValues[index] != null ? paramValues[index] : "null");
            }
        }
        return result.toString();
    }
}

