/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.admin;

import io.axual.common.resolver.GroupResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ExtendableDescribeConsumerGroupsResult;
import org.apache.kafka.common.KafkaFuture;

public class ResolvingDescribeConsumerGroupsResult
extends ExtendableDescribeConsumerGroupsResult {
    protected final GroupResolver groupResolver;
    Map<String, KafkaFuture<ConsumerGroupDescription>> describedGroups;

    public ResolvingDescribeConsumerGroupsResult(Map<String, KafkaFuture<ConsumerGroupDescription>> futures, GroupResolver groupResolver) {
        super(futures);
        this.groupResolver = groupResolver;
        this.describedGroups = new HashMap<String, KafkaFuture<ConsumerGroupDescription>>(futures.size());
        futures.forEach((groupId, future) -> this.describedGroups.put(groupResolver.unresolveGroup(groupId), (KafkaFuture<ConsumerGroupDescription>)future.thenApply(this::unresolvedConsumerGroupDescription)));
    }

    protected ConsumerGroupDescription unresolvedConsumerGroupDescription(ConsumerGroupDescription description) {
        String unresolvedGroupId = this.groupResolver.unresolveGroup(description.groupId());
        return new ConsumerGroupDescription(unresolvedGroupId, description.isSimpleConsumerGroup(), description.members(), description.partitionAssignor(), description.state(), description.coordinator());
    }

    public Map<String, KafkaFuture<ConsumerGroupDescription>> describedGroups() {
        return this.describedGroups;
    }

    public KafkaFuture<Map<String, ConsumerGroupDescription>> all() {
        return KafkaFuture.allOf((KafkaFuture[])this.describedGroups.values().toArray(new KafkaFuture[0])).thenApply(unused -> {
            try {
                HashMap<String, Object> allDescriptions = new HashMap<String, Object>();
                for (Map.Entry<String, KafkaFuture<ConsumerGroupDescription>> entry : this.describedGroups.entrySet()) {
                    allDescriptions.put(entry.getKey(), entry.getValue().get());
                }
                return allDescriptions;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

