/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.admin;

import io.axual.client.proxy.resolving.admin.ResolverUtil;
import io.axual.common.resolver.TopicResolver;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.ExtendableDescribeTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;

public class ResolvingDescribeTopicsResult
extends ExtendableDescribeTopicsResult {
    private final TopicResolver resolver;

    public ResolvingDescribeTopicsResult(Map<Uuid, KafkaFuture<TopicDescription>> topicIdFutures, Map<String, KafkaFuture<TopicDescription>> nameFutures, TopicResolver resolver) {
        super(topicIdFutures, nameFutures);
        this.resolver = resolver;
    }

    @Deprecated
    public ResolvingDescribeTopicsResult(Map<String, KafkaFuture<TopicDescription>> futures, TopicResolver resolver) {
        super(ResolverUtil.unresolve(futures, resolver));
        this.resolver = resolver;
    }

    @Deprecated
    public Map<String, KafkaFuture<TopicDescription>> values() {
        return this.convertFuture(super.values());
    }

    @Deprecated
    public KafkaFuture<Map<String, TopicDescription>> all() {
        return super.all().thenApply(this::convertResult);
    }

    public KafkaFuture<Map<String, TopicDescription>> allTopicNames() {
        return super.allTopicNames().thenApply(this::convertResult);
    }

    public KafkaFuture<Map<Uuid, TopicDescription>> allTopicIds() {
        return super.allTopicIds().thenApply(this::convertResult);
    }

    public Map<String, KafkaFuture<TopicDescription>> topicNameValues() {
        return this.convertFuture(super.topicNameValues());
    }

    public Map<Uuid, KafkaFuture<TopicDescription>> topicIdValues() {
        return this.convertFuture(super.topicIdValues());
    }

    private <T> Map<T, KafkaFuture<TopicDescription>> convertFuture(Map<T, KafkaFuture<TopicDescription>> values) {
        HashMap<T, KafkaFuture> result = new HashMap<T, KafkaFuture>();
        for (Map.Entry<T, KafkaFuture<TopicDescription>> entry : values.entrySet()) {
            result.put(entry.getKey(), entry.getValue().thenApply(this::unresolveTopicDescription));
        }
        return result;
    }

    private <T> Map<T, TopicDescription> convertResult(Map<T, TopicDescription> values) {
        HashMap<T, TopicDescription> result = new HashMap<T, TopicDescription>();
        for (Map.Entry<T, TopicDescription> entry : values.entrySet()) {
            result.put(entry.getKey(), this.unresolveTopicDescription(entry.getValue()));
        }
        return result;
    }

    private TopicDescription unresolveTopicDescription(TopicDescription td) {
        return new TopicDescription(this.resolver.unresolveTopic(td.name()), td.isInternal(), td.partitions(), td.authorizedOperations());
    }
}

