/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.admin;

import io.axual.common.resolver.GroupResolver;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.ExtendableListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.common.KafkaFuture;

public class ResolvingListConsumerGroupsResult
extends ExtendableListConsumerGroupsResult {
    protected final GroupResolver groupResolver;
    protected final KafkaFuture<Collection<ConsumerGroupListing>> all;
    protected final KafkaFuture<Collection<ConsumerGroupListing>> valid;

    public ResolvingListConsumerGroupsResult(ListConsumerGroupsResult listConsumerGroupsResult, GroupResolver groupResolver) {
        super(listConsumerGroupsResult);
        this.groupResolver = groupResolver;
        this.all = listConsumerGroupsResult.all().thenApply(this::unresolveConsumerGroupListings);
        this.valid = listConsumerGroupsResult.valid().thenApply(this::unresolveConsumerGroupListings);
    }

    private Collection<ConsumerGroupListing> unresolveConsumerGroupListings(Collection<ConsumerGroupListing> consumerGroupListings) {
        return consumerGroupListings.stream().map(this::unresolveConsumerGroupListings).collect(Collectors.toList());
    }

    private ConsumerGroupListing unresolveConsumerGroupListings(ConsumerGroupListing consumerGroupListing) {
        String unresolvedGroupId = this.groupResolver.unresolveGroup(consumerGroupListing.groupId());
        return new ConsumerGroupListing(unresolvedGroupId, consumerGroupListing.isSimpleConsumerGroup(), consumerGroupListing.state());
    }

    @Override
    public KafkaFuture<Collection<ConsumerGroupListing>> all() {
        return this.all;
    }

    @Override
    public KafkaFuture<Collection<ConsumerGroupListing>> valid() {
        return this.valid;
    }
}

