/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.admin;

import io.axual.common.resolver.TopicResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.ExtendableListTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;

public class ResolvingListTopicsResult
extends ExtendableListTopicsResult {
    private final ListTopicsResult rawResult;
    private final TopicResolver resolver;

    public ResolvingListTopicsResult(ListTopicsResult rawResult, TopicResolver resolver) {
        super(null);
        this.rawResult = rawResult;
        this.resolver = resolver;
    }

    public KafkaFuture<Map<String, TopicListing>> namesToListings() {
        return this.rawResult.namesToListings().thenApply((KafkaFuture.Function)new KafkaFuture.Function<Map<String, TopicListing>, Map<String, TopicListing>>(){

            public Map<String, TopicListing> apply(Map<String, TopicListing> rawResult) {
                HashMap<String, TopicListing> result = new HashMap<String, TopicListing>();
                for (Map.Entry<String, TopicListing> entry : rawResult.entrySet()) {
                    String unresolvedTopic = entry.getValue().isInternal() ? entry.getKey() : ResolvingListTopicsResult.this.resolver.unresolveTopic(entry.getKey());
                    if (unresolvedTopic == null) continue;
                    result.put(unresolvedTopic, new TopicListing(unresolvedTopic, entry.getValue().isInternal()));
                }
                return result;
            }
        });
    }

    public KafkaFuture<Collection<TopicListing>> listings() {
        return this.rawResult.listings().thenApply((KafkaFuture.Function)new KafkaFuture.Function<Collection<TopicListing>, Collection<TopicListing>>(){

            public Collection<TopicListing> apply(Collection<TopicListing> rawResult) {
                HashSet<TopicListing> result = new HashSet<TopicListing>();
                for (TopicListing rawListing : rawResult) {
                    if (rawListing.isInternal()) {
                        result.add(new TopicListing(rawListing.name(), rawListing.isInternal()));
                        continue;
                    }
                    String unresolved = ResolvingListTopicsResult.this.resolver.unresolveTopic(rawListing.name());
                    if (unresolved == null) continue;
                    result.add(new TopicListing(unresolved, rawListing.isInternal()));
                }
                return result;
            }
        });
    }

    public KafkaFuture<Set<String>> names() {
        return this.rawResult.names().thenApply((KafkaFuture.Function)new KafkaFuture.Function<Set<String>, Set<String>>(){

            public Set<String> apply(Set<String> rawResult) {
                return ResolvingListTopicsResult.this.resolver.unresolveTopics(rawResult);
            }
        });
    }
}

