/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.consumer;

import io.axual.client.proxy.generic.consumer.ConsumerProxy;
import io.axual.client.proxy.generic.consumer.StaticConsumerProxy;
import io.axual.client.proxy.generic.tools.SerdeUtil;
import io.axual.client.proxy.resolving.consumer.ResolvingConsumerConfig;
import io.axual.client.proxy.resolving.consumer.ResolvingPartitionInfo;
import io.axual.common.tools.MapUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;

public class ResolvingConsumer<K, V>
extends StaticConsumerProxy<K, V, ResolvingConsumerConfig<K, V>> {
    public ResolvingConsumer(Map<String, Object> configs) {
        super(new ResolvingConsumerConfig(configs));
    }

    public ResolvingConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(SerdeUtil.addDeserializersToConfigs(configs, keyDeserializer, valueDeserializer));
    }

    public ResolvingConsumer(Properties properties) {
        this(MapUtil.objectToStringMap((Map)properties));
    }

    public ResolvingConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(MapUtil.objectToStringMap((Map)properties), keyDeserializer, valueDeserializer);
    }

    @Override
    public Set<TopicPartition> assignment() {
        return ((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopicPartitions(super.assignment());
    }

    @Override
    public Set<String> subscription() {
        return ((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopics(super.subscription());
    }

    @Override
    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        super.subscribe(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopics(topics), this.convertListener(listener));
    }

    @Override
    public void subscribe(Collection<String> topics) {
        super.subscribe(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopics(topics));
    }

    @Override
    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        Pattern resolvedPattern = ((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPattern(pattern);
        super.subscribe(resolvedPattern, this.convertListener(listener));
    }

    @Override
    public void subscribe(Pattern pattern) {
        this.operationNotSupported("subscribing to patterns");
    }

    @Override
    public void assign(Collection<TopicPartition> partitions) {
        super.assign(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions));
    }

    @Override
    @Deprecated
    public ConsumerRecords<K, V> poll(long timeout) {
        return this.convertRecords(super.poll(timeout));
    }

    @Override
    public ConsumerRecords<K, V> poll(Duration timeout) {
        return this.convertRecords(super.poll(timeout));
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        super.commitSync(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopics(offsets));
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        super.commitSync(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopics(offsets), timeout);
    }

    @Override
    public void commitAsync(OffsetCommitCallback callback) {
        if (callback == null) {
            super.commitAsync(null);
        } else {
            super.commitAsync(new ProxyOffsetCommitCallback(callback));
        }
    }

    @Override
    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        if (callback == null) {
            super.commitAsync(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopics(offsets), null);
        } else {
            super.commitAsync(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopics(offsets), new ProxyOffsetCommitCallback(callback));
        }
    }

    @Override
    public void seek(TopicPartition partition, long offset) {
        super.seek(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopic(partition), offset);
    }

    @Override
    public void seek(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        Set resolvedTopicPartition = ((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(Collections.singleton(topicPartition));
        super.seek(resolvedTopicPartition.toArray(new TopicPartition[1])[0], offsetAndMetadata);
    }

    @Override
    public void seekToBeginning(Collection<TopicPartition> partitions) {
        super.seekToBeginning(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions));
    }

    @Override
    public void seekToEnd(Collection<TopicPartition> partitions) {
        super.seekToEnd(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions));
    }

    @Override
    public long position(TopicPartition partition) {
        return super.position(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopic(partition));
    }

    @Override
    public long position(TopicPartition topicPartition, Duration duration) {
        return super.position(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopic(topicPartition), duration);
    }

    @Override
    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition) {
        return super.committed(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopic(partition));
    }

    @Override
    @Deprecated
    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        return super.committed(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopic(partition), timeout);
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return this.unresolveTopicPartitionOffsetAndMetadataMap(super.committed(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions)));
    }

    @Override
    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        return this.unresolveTopicPartitionOffsetAndMetadataMap(super.committed(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions), timeout));
    }

    @Override
    public ConsumerGroupMetadata groupMetadata() {
        ConsumerGroupMetadata groupMetadata = super.groupMetadata();
        return groupMetadata == null ? null : new ConsumerGroupMetadata(((ResolvingConsumerConfig)this.config).getGroupResolver().unresolveGroup(groupMetadata.groupId()), groupMetadata.generationId(), groupMetadata.memberId(), groupMetadata.groupInstanceId());
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this.convertPartitionInfo(super.partitionsFor(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopic(topic)), topic);
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        return this.convertPartitionInfo(super.partitionsFor(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopic(topic), timeout), topic);
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics() {
        return this.convertTopicList(super.listTopics());
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        return this.convertTopicList(super.listTopics(timeout));
    }

    @Override
    public void pause(Collection<TopicPartition> partitions) {
        super.pause(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions));
    }

    @Override
    public void resume(Collection<TopicPartition> partitions) {
        super.resume(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions));
    }

    @Override
    public Set<TopicPartition> paused() {
        return ((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopicPartitions(super.paused());
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return ((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopics(super.offsetsForTimes(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopics(timestampsToSearch)));
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        return ((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopics(super.offsetsForTimes(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopics(timestampsToSearch), timeout));
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return ((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopics(super.beginningOffsets(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions)));
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return ((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopics(super.beginningOffsets(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions), timeout));
    }

    @Override
    public OptionalLong currentLag(TopicPartition topicPartition) {
        return ((ConsumerProxy)this.proxiedObject).currentLag(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopic(topicPartition));
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return ((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopics(super.endOffsets(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions)));
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return ((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopics(super.endOffsets(((ResolvingConsumerConfig)this.config).getTopicResolver().resolveTopicPartitions(partitions), timeout));
    }

    private ConsumerRebalanceListener convertListener(ConsumerRebalanceListener listener) {
        return listener != null ? new ProxyConsumerRebalanceListener(listener) : null;
    }

    private ConsumerRecords<K, V> convertRecords(ConsumerRecords<K, V> records) {
        HashMap recordsByPartition = new HashMap();
        if (!records.isEmpty()) {
            for (TopicPartition topicPartition : records.partitions()) {
                ArrayList<ConsumerRecord> partitionRecords = new ArrayList<ConsumerRecord>();
                for (ConsumerRecord consumerRecord : records.records(topicPartition)) {
                    partitionRecords.add(new ConsumerRecord(((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopic(consumerRecord.topic()), consumerRecord.partition(), consumerRecord.offset(), consumerRecord.timestamp(), consumerRecord.timestampType(), consumerRecord.serializedKeySize(), consumerRecord.serializedValueSize(), consumerRecord.key(), consumerRecord.value(), consumerRecord.headers(), consumerRecord.leaderEpoch()));
                }
                recordsByPartition.put(((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopic(topicPartition), partitionRecords);
            }
        }
        return new ConsumerRecords(recordsByPartition);
    }

    private Map<String, List<PartitionInfo>> convertTopicList(Map<String, List<PartitionInfo>> topicList) {
        HashMap<String, List<PartitionInfo>> result = new HashMap<String, List<PartitionInfo>>(topicList.size());
        for (Map.Entry<String, List<PartitionInfo>> entry : topicList.entrySet()) {
            String topic = entry.getKey();
            List<PartitionInfo> infos = topicList.get(topic);
            ArrayList<ResolvingPartitionInfo> resultInfos = new ArrayList<ResolvingPartitionInfo>(infos.size());
            for (PartitionInfo info : infos) {
                resultInfos.add(new ResolvingPartitionInfo(((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopic(info.topic()), info.partition()));
            }
            result.put(((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopic(topic), resultInfos);
        }
        return result;
    }

    private List<PartitionInfo> convertPartitionInfo(List<PartitionInfo> partitionInfoList, String unresolvedTopic) {
        if (partitionInfoList == null) {
            return null;
        }
        ArrayList<PartitionInfo> result = new ArrayList<PartitionInfo>(partitionInfoList.size());
        for (PartitionInfo partitionInfo : partitionInfoList) {
            result.add(new ResolvingPartitionInfo(unresolvedTopic, partitionInfo.partition()));
        }
        return result;
    }

    private Map<TopicPartition, OffsetAndMetadata> unresolveTopicPartitionOffsetAndMetadataMap(Map<TopicPartition, OffsetAndMetadata> topicPartitionOffsetAndMetadataMap) {
        return topicPartitionOffsetAndMetadataMap == null || topicPartitionOffsetAndMetadataMap.isEmpty() ? topicPartitionOffsetAndMetadataMap : (Map)topicPartitionOffsetAndMetadataMap.keySet().stream().collect(HashMap::new, (map, topicPartition) -> {
            OffsetAndMetadata cfr_ignored_0 = (OffsetAndMetadata)map.put(new TopicPartition(((ResolvingConsumerConfig)this.config).getTopicResolver().unresolveTopic(topicPartition.topic()), topicPartition.partition()), topicPartitionOffsetAndMetadataMap.get(topicPartition));
        }, HashMap::putAll);
    }

    private final class ProxyOffsetCommitCallback
    implements OffsetCommitCallback {
        private OffsetCommitCallback callback;

        ProxyOffsetCommitCallback(OffsetCommitCallback callback) {
            this.callback = callback;
        }

        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception e) {
            this.callback.onComplete(((ResolvingConsumerConfig)ResolvingConsumer.this.config).getTopicResolver().unresolveTopics(offsets), e);
        }
    }

    private final class ProxyConsumerRebalanceListener
    implements ConsumerRebalanceListener {
        private ConsumerRebalanceListener listener;

        ProxyConsumerRebalanceListener(ConsumerRebalanceListener listener) {
            this.listener = listener;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> collection) {
            this.listener.onPartitionsRevoked((Collection)((ResolvingConsumerConfig)ResolvingConsumer.this.config).getTopicResolver().unresolveTopicPartitions(collection));
        }

        public void onPartitionsAssigned(Collection<TopicPartition> collection) {
            this.listener.onPartitionsAssigned((Collection)((ResolvingConsumerConfig)ResolvingConsumer.this.config).getTopicResolver().unresolveTopicPartitions(collection));
        }
    }
}

