/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.resolving.producer;

import io.axual.client.proxy.generic.producer.ProducerProxy;
import io.axual.client.proxy.resolving.generic.ResolvingClientProxyConfig;
import io.axual.common.resolver.GroupResolver;
import io.axual.common.resolver.TransactionalIdResolver;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvingProducerConfig<K, V>
extends ResolvingClientProxyConfig<ProducerProxy<K, V>> {
    public static final String BACKING_FACTORY_CONFIG = "resolvingproducer.backing.factory";
    public static final String GROUP_ID_RESOLVER_CONFIG = "group.id.resolver";
    public static final String TRANSACTIONAL_ID_RESOLVER_CONFIG = "transactional.id.resolver";
    public static final String TRANSACTIONAL_ID = "transactional.id";
    private static final Logger log = LoggerFactory.getLogger(ResolvingProducerConfig.class);
    private final GroupResolver groupResolver = (GroupResolver)this.getConfiguredInstance("group.id.resolver", GroupResolver.class);
    private TransactionalIdResolver transactionalIdResolver;

    public ResolvingProducerConfig(Map<String, Object> configs) {
        super(configs, BACKING_FACTORY_CONFIG);
        this.groupResolver.configure(configs);
        String transactionalId = (String)configs.get(TRANSACTIONAL_ID);
        if (transactionalId != null) {
            this.transactionalIdResolver = (TransactionalIdResolver)this.getConfiguredInstance(TRANSACTIONAL_ID_RESOLVER_CONFIG, TransactionalIdResolver.class, false);
            this.putDownstream(TRANSACTIONAL_ID, this.resolveTransactionalId(transactionalId));
        }
    }

    public GroupResolver getGroupResolver() {
        return this.groupResolver;
    }

    private String resolveTransactionalId(String transactionalId) {
        String result = this.transactionalIdResolver.resolveTransactionalId(transactionalId);
        if (result == null) {
            log.warn("Failed to resolve transactional.id={}, leaving as is", (Object)transactionalId);
            return transactionalId;
        }
        return result;
    }
}

