/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.switching.generic;

import io.axual.client.proxy.generic.client.ClientProxy;
import io.axual.client.proxy.generic.config.DynamicClientProxyConfig;
import io.axual.client.proxy.switching.generic.ClientProxySwitcher;
import io.axual.common.tools.MapUtil;
import io.axual.common.tools.SleepUtil;
import io.axual.discovery.client.DiscoveryResult;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClientProxySwitcher<T extends ClientProxy, C extends DynamicClientProxyConfig>
implements ClientProxySwitcher<T, C> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseClientProxySwitcher.class);
    private static final long DEFAULT_DISTRIBUTOR_DISTANCE = 1L;
    private static final long DEFAULT_DISTRIBUTOR_TIMEOUT = 60000L;

    @Override
    public T switchProxy(T oldProxy, C config, DiscoveryResult oldResult, DiscoveryResult newResult) {
        Duration switchTimeout;
        if (oldProxy != null) {
            oldProxy.close();
        }
        if (newResult == null || newResult.getCluster() == null) {
            LOG.warn("Can not create a new proxy based on discovery result: {}", (Object)newResult);
            return null;
        }
        if (oldResult != null && !Objects.equals(oldResult.getCluster(), newResult.getCluster()) && oldProxy != null && (switchTimeout = this.getSwitchTimeout(config, oldResult, newResult)).toMillis() > 0L) {
            LOG.info("Sleeping before switching {}, switch timeout = {}", (Object)oldProxy.getClass().getSimpleName(), (Object)switchTimeout);
            SleepUtil.sleep((Duration)switchTimeout);
            LOG.info("Sleeping of {} done", (Object)this.getClass().getSimpleName());
        }
        LOG.info("Creating new backing {} with Discovery API result: {}", (Object)((DynamicClientProxyConfig)((Object)config)).getProxyType(), (Object)newResult);
        T result = this.createProxyObject(config, newResult);
        LOG.info("Created new backing {}", (Object)((DynamicClientProxyConfig)((Object)config)).getProxyType());
        return result;
    }

    protected abstract T createProxyObject(C var1, DiscoveryResult var2);

    protected Duration getSwitchTimeout(C config, DiscoveryResult oldResult, DiscoveryResult newResult) {
        long timePassedSinceDiscovery = Math.max(System.currentTimeMillis() - newResult.getTimestamp(), 0L);
        return Duration.ofMillis(this.getDistributorTimeout(newResult) * this.getDistributorDistance(newResult) - timePassedSinceDiscovery);
    }

    protected long getDistributorTimeout(DiscoveryResult discoveryResult) {
        String dto = MapUtil.stringValue((Map)discoveryResult.getConfigs(), (Object)"distributor.timeout");
        return dto != null ? Long.parseLong(dto) : 60000L;
    }

    private long getDistributorDistance(DiscoveryResult discoveryResult) {
        String ddst = MapUtil.stringValue((Map)discoveryResult.getConfigs(), (Object)"distributor.distance");
        return ddst != null ? Long.parseLong(ddst) : 1L;
    }
}

