/*
 * Decompiled with CFR 0.152.
 */
package io.axual.client.proxy.wrapped;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetAndMetadataUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OffsetAndMetadataUtil.class);
    private static final String FIELD_NAME_COPY_FLAGS = "copyFlags";
    public static final OffsetAndMetadataUtil INSTANCE = new OffsetAndMetadataUtil();
    private final ObjectMapper objectMapper = new ObjectMapper();

    private OffsetAndMetadataUtil() {
    }

    public OffsetAndMetadata cleanMetadata(OffsetAndMetadata offsetAndMetadata) {
        if (offsetAndMetadata == null) {
            return null;
        }
        String metadata = offsetAndMetadata.metadata().trim();
        if (metadata.startsWith("{")) {
            try {
                JsonNode rootNode = this.objectMapper.readTree(metadata);
                if (rootNode.has(FIELD_NAME_COPY_FLAGS)) {
                    return new OffsetAndMetadata(offsetAndMetadata.offset(), offsetAndMetadata.leaderEpoch(), null);
                }
            }
            catch (JsonProcessingException e) {
                LOG.trace("Could not parse JSON Metadata for offset", (Throwable)e);
            }
        }
        return offsetAndMetadata;
    }

    public <K> Map<K, OffsetAndMetadata> cleanMetadata(Map<K, OffsetAndMetadata> offsetAndMetadataMap) {
        Objects.requireNonNull(offsetAndMetadataMap);
        HashMap cleaned = new HashMap(offsetAndMetadataMap.size());
        offsetAndMetadataMap.forEach((k, v) -> cleaned.put(k, this.cleanMetadata((OffsetAndMetadata)v)));
        return cleaned;
    }
}

